#include "buttonwidget.h"

ButtonWidget::ButtonWidget(QWidget *parent, const QString aFilenameUnpressed,const QString aFileNamePressed,
                           const QString aConfFileName, const QString aButtonText, const QStringList commands, int time) : QWidget( parent )
{
        allowText = false;
        fileNamePressed = aFileNamePressed;
        fileNameUnPressed = aFilenameUnpressed;
        confFileName = aConfFileName;
        buttonText = aButtonText;
        commandChain = commands;
        timeOut = time;

        textUpSize = 30;
        textDownSize = 29;
        textUpWeight = 50;
        textDownWeight = 50;
        textUpColor = new QColor(255,255,255);
        textDownColor = new QColor(255,255,255);

        if(fileNameUnPressed.contains("/home/user/MyDocs/qtirreco/themes/",Qt::CaseInsensitive)) {
            fileNameUnPressed = aFilenameUnpressed;
            fileNamePressed = aFileNamePressed;
            confFileName = aConfFileName;
        }
        else checkButtonCommand();

        QFile file(confFileName);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with button config","Failed to load button config",
                     QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }

        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line);
        }

        if(upFontFamily.isEmpty())
            upFontFamily = "sans-serif";

        if(downFontFamily.isEmpty())
            downFontFamily = "sans-serif";

        pressedPixmap = new QPixmap( fileNamePressed);
        unpressedPixmap = new QPixmap( fileNameUnPressed);
        if(buttonText.count() > 5) {
            textUpSize-=(buttonText.count()+1);
            textDownSize-=(buttonText.count()+1);
        }
        textUpFont = new QFont(upFontFamily, textUpSize, textUpWeight, false);
        textDownFont = new QFont(downFontFamily, textDownSize, textDownWeight, false);
        this->resize(unpressedPixmap->width()+1,unpressedPixmap->height()+1);
        this->update();
}

ButtonWidget::~ButtonWidget()
{

}


void ButtonWidget::process_line(QString line)
{
    if(line.contains("allow-text=true",Qt::CaseInsensitive))
        allowText = true;

    if(line.contains("text-format-up",Qt::CaseInsensitive)) {
        QString lineForeground = line;

        if(line.contains("font_family=",Qt::CaseInsensitive)) {
            QString tempLine = line;
            int family = tempLine.indexOf("font_family=") + 12;
            tempLine.remove(0,family);
            int size = tempLine.indexOf("size=");
            int count = tempLine.count();
            tempLine.chop(count - size);
            upFontFamily = tempLine;
        }
        if(line.contains("font_desc=",Qt::CaseInsensitive)) {
            QStringList list = line.split(QRegExp("\\b"));
            if(list.contains("Light",Qt::CaseInsensitive))
                textUpWeight = 25;
            if(list.contains("Normal",Qt::CaseInsensitive))
                textUpWeight = 50;
            if(list.contains("Bold",Qt::CaseInsensitive))
                textUpWeight = 75;
            upFontFamily = list.at(0);

        }

        if(line.contains("size=",Qt::CaseInsensitive)) {
            int i;
            int x;
            int lineLength;
            int chopLength;
            QString y = "size=";
            QString w = "weight";
            i = line.indexOf(y);
            line.remove(0,(i+6));
            x = line.indexOf(w);
            lineLength = line.length();
            chopLength = lineLength - x + 2;
            line.chop(chopLength);


            textUpSize = line.toInt();
            textUpSize = textUpSize / 1024;
        }
            if(line.contains("weight=",Qt::CaseInsensitive)) {
                int i;
                int x;
                int lineLength;
                int chopLength;
                QString y = "weight=";
                QString w = "foreground";
                i = line.indexOf(y);
                line.remove(0,(i+7));
                x = line.indexOf(w);
                lineLength = line.length();
                chopLength = lineLength - x + 2;
                line.chop(chopLength);


                if(line.contains("Light",Qt::CaseInsensitive))
                    textUpWeight = 25;
                if(line.contains("Normal",Qt::CaseInsensitive))
                    textUpWeight = 50;
                if(line.contains("Bold",Qt::CaseInsensitive))
                    textUpWeight = 75;
            }

        if(lineForeground.contains("foreground=",Qt::CaseInsensitive)) {
            bool ok;
            QString y = "foreground=";
            iU = lineForeground.indexOf(y);
            lineForeground.remove(0,(iU+13));

            rU = lineForeground.mid(0,2).toInt(&ok,16);
            gU = lineForeground.mid(2,2).toInt(&ok,16);
            bU = lineForeground.mid(4,2).toInt(&ok,16);

            textUpColor = new QColor(rU,gU,bU);
        }
    }

    if(line.contains("text-format-down",Qt::CaseInsensitive)) {
        if(line.contains("font_family=",Qt::CaseInsensitive)) {
            QString tempLine = line;
            int family = tempLine.indexOf("font_family=") + 12;
            tempLine.remove(0,family);
            int size = tempLine.indexOf("size=");
            int count = tempLine.count();
            tempLine.chop(count - size);
            downFontFamily = tempLine;
        }
        if(line.contains("font_desc=",Qt::CaseInsensitive)) {
        QStringList list = line.split(QRegExp("\\b"));
        if(list.contains("Light",Qt::CaseInsensitive))
            textDownWeight = 25;
        if(list.contains("Normal",Qt::CaseInsensitive))
            textDownWeight = 50;
        if(list.contains("Bold",Qt::CaseInsensitive))
            textDownWeight = 75;
        downFontFamily = list.at(0);
        }

        if(line.contains("size=",Qt::CaseInsensitive)) {
            int i;
            int x;
            int lineLength;
            int chopLength;
            QString y = "size=";
            QString w = "weight";
            i = line.indexOf(y);
            line.remove(0,(i+6));
            x = line.indexOf(w);
            lineLength = line.length();
            chopLength = lineLength - x + 2;
            line.chop(chopLength);

            textDownSize = line.toInt();
            textDownSize = textDownSize / 1024;
        }
        if(line.contains("weight=",Qt::CaseInsensitive)) {
            int i;
            int x;
            int lineLength;
            int chopLength;
            QString y = "weight=";
            QString w = "foreground";
            i = line.indexOf(y);
            line.remove(0,(i+7));
            x = line.indexOf(w);
            lineLength = line.length();
            chopLength = lineLength - x + 2;
            line.chop(chopLength);

            if(line.contains("Light",Qt::CaseInsensitive))
                textDownWeight = 25;
            if(line.contains("Normal",Qt::CaseInsensitive))
                textDownWeight = 50;
            if(line.contains("DemiBold",Qt::CaseInsensitive))
                textDownWeight = 63;
            if(line.contains("Bold",Qt::CaseInsensitive))
                textDownWeight = 75;
            if(line.contains("Black",Qt::CaseInsensitive))
                textDownWeight = 87;
        }
        if(line.contains("foreground=",Qt::CaseInsensitive)) {
            bool ok;
            int i,r,g,b;
            QString y = "foreground=";
            i = line.indexOf(y);
            line.remove(0,(i+13));

            r = line.mid(0,2).toInt(&ok,16);
            g = line.mid(2,2).toInt(&ok,16);
            b = line.mid(4,2).toInt(&ok,16);

            textDownColor = new QColor(r,g,b);
        }
    }
}

void ButtonWidget::paintEvent( QPaintEvent* event)
{
        QPainter p;
        p.begin(this);
        p.save();
        p.drawPixmap(0, 0, *unpressedPixmap );
        if(allowText && !buttonText.contains("blank",Qt::CaseInsensitive)) {
            p.setPen(*textUpColor);
            p.setFont(*textUpFont);
            p.drawText(this->rect(),Qt::AlignCenter,buttonText);
        }
        p.restore();
        p.end();
}

void ButtonWidget::checkButtonCommand()
{
        if(fileNameUnPressed.contains("up",Qt::CaseSensitive) && buttonText == "Up" || buttonText == "up")
        {
            fileNameUnPressed = defaultButtonsPath + "up/unpressed.png";
            fileNamePressed = defaultButtonsPath + "up/pressed.png";
            confFileName = defaultButtonsPath + "up/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("down",Qt::CaseSensitive) && buttonText == "Down" || buttonText == "down")
        {
            fileNameUnPressed = defaultButtonsPath + "down/unpressed.png";
            fileNamePressed = defaultButtonsPath + "down/pressed.png";
            confFileName = defaultButtonsPath + "down/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("left",Qt::CaseSensitive) && buttonText == "Left" || buttonText == "left")
        {
            fileNameUnPressed = defaultButtonsPath + "left/unpressed.png";
            fileNamePressed = defaultButtonsPath + "left/pressed.png";
            confFileName = defaultButtonsPath + "left/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("right",Qt::CaseSensitive) && buttonText == "Right" || buttonText == "right")
        {
            fileNameUnPressed = defaultButtonsPath + "right/unpressed.png";
            fileNamePressed = defaultButtonsPath + "right/pressed.png";
            confFileName = defaultButtonsPath + "right/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("next",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "next/unpressed.png";
            fileNamePressed = defaultButtonsPath + "next/pressed.png";
            confFileName = defaultButtonsPath + "next/button.conf";
            return;
        }
        if(fileNameUnPressed == "0" || fileNameUnPressed.contains("num_0",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_0/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_0/pressed.png";
            confFileName = defaultButtonsPath + "num_0/button.conf";
            return;
        }
        if(fileNameUnPressed == "1" || fileNameUnPressed.contains("num_1",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_1/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_1/pressed.png";
            confFileName = defaultButtonsPath + "num_1/button.conf";
            return;
        }
        if(fileNameUnPressed == "2" || fileNameUnPressed.contains("num_2",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_2/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_2/pressed.png";
            confFileName = defaultButtonsPath + "num_2/button.conf";
            return;
        }
        if(fileNameUnPressed == "3" || fileNameUnPressed.contains("num_3",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_3/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_3/pressed.png";
            confFileName = defaultButtonsPath + "num_3/button.conf";
            return;
        }
        if(fileNameUnPressed == "4" || fileNameUnPressed.contains("num_4",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_4/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_4/pressed.png";
            confFileName = defaultButtonsPath + "num_4/button.conf";
            return;
        }
        if(fileNameUnPressed == "5" || fileNameUnPressed.contains("num_5",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_5/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_5/pressed.png";
            confFileName = defaultButtonsPath + "num_5/button.conf";
            return;
        }
        if(fileNameUnPressed == "6" || fileNameUnPressed.contains("num_6",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_6/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_6/pressed.png";
            confFileName = defaultButtonsPath + "num_6/button.conf";
            return;
        }
        if(fileNameUnPressed == "7" || fileNameUnPressed.contains("num_7",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_7/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_7/pressed.png";
            confFileName = defaultButtonsPath + "num_7/button.conf";
            return;
        }
        if(fileNameUnPressed == "8" || fileNameUnPressed.contains("num_8",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_8/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_8/pressed.png";
            confFileName = defaultButtonsPath + "num_8/button.conf";
            return;
        }
        if(fileNameUnPressed == "9" || fileNameUnPressed.contains("num_9",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "num_9/unpressed.png";
            fileNamePressed = defaultButtonsPath + "num_9/pressed.png";
            confFileName = defaultButtonsPath + "num_9/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("ok",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "ok/unpressed.png";
            fileNamePressed = defaultButtonsPath + "ok/pressed.png";
            confFileName = defaultButtonsPath + "ok/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("pause",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "pause/unpressed.png";
            fileNamePressed = defaultButtonsPath + "pause/pressed.png";
            confFileName = defaultButtonsPath + "pause/button.conf";
            return;
        }
        if(fileNameUnPressed == "play" || fileNameUnPressed == "Play" || fileNameUnPressed == "PLAY")
        {
            fileNameUnPressed = defaultButtonsPath + "right/unpressed.png";
            fileNamePressed = defaultButtonsPath + "right/pressed.png";
            confFileName = defaultButtonsPath + "right/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("play",Qt::CaseInsensitive) && fileNameUnPressed.contains("pause",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "pause/unpressed.png";
            fileNamePressed = defaultButtonsPath + "pause/pressed.png";
            confFileName = defaultButtonsPath + "pause/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("power",Qt::CaseInsensitive) || fileNameUnPressed == "ONOFF" || fileNameUnPressed == "ON/OFF" ||
           fileNameUnPressed == "on/off" || fileNameUnPressed == "On/Off")
        {
            fileNameUnPressed = defaultButtonsPath + "power/unpressed.png";
            fileNamePressed = defaultButtonsPath + "power/pressed.png";
            confFileName = defaultButtonsPath + "power/button.conf";
            return;
        }
        if(fileNameUnPressed.contains("prev",Qt::CaseInsensitive))
        {
            fileNameUnPressed = defaultButtonsPath + "prev/unpressed.png";
            fileNamePressed = defaultButtonsPath + "prev/pressed.png";
            confFileName = defaultButtonsPath + "prev/button.conf";
            return;
        }
        else
        {
            fileNameUnPressed = defaultButtonsPath + "blank/unpressed.png";
            fileNamePressed = defaultButtonsPath + "blank/pressed.png";
            confFileName = defaultButtonsPath + "blank/button.conf";
        }
}
