#include "commandchaindlg.h"
#include "ui_commandchaindlg.h"

CommandChainDlg::CommandChainDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::CommandChainDlg)
{
    m_ui->setupUi(this);

    flag = false;
    raw_flag = false;
    QDir *dir = new QDir("/home/user/MyDocs/qtirreco/Devices/");
    models = dir->entryList(QDir::NoDotAndDotDot | QDir::Files, QDir::Name);
    m_ui->remoteListWidget->addItems(models);
    m_ui->remoteListWidget->sortItems(Qt::AscendingOrder);
    m_ui->deleteRemoteButton->setDisabled(true);

    connect(m_ui->remoteListWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(getCommands(QListWidgetItem*)));
    connect(m_ui->commandlistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(commandItemClicked(QListWidgetItem*)));
    connect(m_ui->deleteRemoteButton,SIGNAL(clicked()),this,SLOT(deleteRemote()));
}

CommandChainDlg::~CommandChainDlg()
{
    delete m_ui;
}

void CommandChainDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void CommandChainDlg::commandItemClicked(QListWidgetItem* item)
{
    emit signalAddCommand(item->text(),m_ui->remoteListWidget->currentItem()->text(),"1");
    this->close();
}
void CommandChainDlg::getCommands(QListWidgetItem* item)
{
    commands.clear();
    m_ui->deleteRemoteButton->setEnabled(true);
    QFile file("/home/user/MyDocs/qtirreco/Devices/" + item->text());
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::warning(this,"Error with remote config","Couldn't load remote config file!",
                             QMessageBox::NoButton,QMessageBox::NoButton);
        return;
    }

    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        if(line.contains("end remote",Qt::CaseInsensitive)) {
            m_ui->commandlistWidget->clear();
            m_ui->commandlistWidget->insertItems(0,commands);
            m_ui->commandlistWidget->sortItems(Qt::AscendingOrder);
            break;
        }
        else process_line(line);
    }
    file.close();
    in.reset();
}
void CommandChainDlg::process_line(QString line)
{
    if(line.contains("end codes", Qt::CaseInsensitive))
           flag = false;
    if(line.contains("end raw_codes", Qt::CaseInsensitive))
           raw_flag = false;
    if(flag) {
        if(line.contains("0x",Qt::CaseInsensitive)) {
            QString commandName = line;
            int lineLength;
            QString finalCommandName;

            commandName = commandName.trimmed();
            lineLength = commandName.length();

            for (int i=0;i<lineLength;i++) {
                 if(commandName.at(i).isSpace() == false)
                     finalCommandName.append(commandName.at(i));
                 if(commandName.at(i).isSpace() == true)
                     break;
             }

            commands.append(finalCommandName);
        }
    }
    if(raw_flag) {
         if(line.contains("name", Qt::CaseInsensitive)) {
            line = line.trimmed();
            line.remove(0,5);
            commands.append(line);
         }
    }
    if(line.contains("begin codes", Qt::CaseInsensitive))
        flag = true;
    if(line.contains("begin raw_codes", Qt::CaseInsensitive))
        raw_flag = true;
}
void CommandChainDlg::deleteRemote()
{
    remoteName = m_ui->remoteListWidget->currentItem()->text();
    confFileInUse = false;
    QDir *lircDir = new QDir("/home/user/MyDocs/qtirreco/Remotes/");

    lircConfs = lircDir->entryList(QDir::Files);

    for(int i = 0 ; i < lircConfs.count() ; i++) {

        if(lircConfs.at(i) != "remotes.conf")
        {
            QString remoteFile;
            remoteFile = "/home/user/MyDocs/qtirreco/Remotes/" + lircConfs.at(i);
            QFile file(remoteFile);
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
                    QMessageBox::warning(this,"Error with remote config","Couldn't load remote config file!",
                                         QMessageBox::NoButton,QMessageBox::NoButton);
                    return;
                }

                QTextStream in(&file);
                while (!in.atEnd()) {
                    QString line = in.readLine();
                    read_line(line,i);
                }
                file.close();
        }
    }

    if(!confFileInUse)
    {
        m_ui->commandlistWidget->clear();
        delete m_ui->remoteListWidget->currentItem();

        QFile remoteFile;
        remoteFile.remove("/home/user/MyDocs/qtirreco/Devices/" + remoteName);

        QFile LircConfFile("/etc/lircd.conf");
        QStringList deviceList;
        LircConfFile.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream io(&LircConfFile);
        while (!io.atEnd()) {
            QString line = io.readLine();
            deviceList.append(line);
        }
        for(int i = 0; i<deviceList.count();i++) {
            if(deviceList.at(i) =="include \"/home/user/MyDocs/qtirreco/Devices/" + remoteName +"\"")
            deviceList.removeAt(i);
        }
        LircConfFile.close();
        LircConfFile.open(QIODevice::WriteOnly | QIODevice::Text);
        io.reset();
        for(int i= 0; i< deviceList.count();i++) {
            io << deviceList.at(i)+"\n";
        }
        if(m_ui->remoteListWidget->count() < 1)
            m_ui->deleteRemoteButton->setDisabled(true);
        LircConfFile.close();

        QFile LircPathFile("/home/user/MyDocs/qtirreco/lircpaths.conf");
        QStringList pathList;
        LircPathFile.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream inout(&LircPathFile);
        while (!inout.atEnd()) {
            QString line = inout.readLine();
            pathList.append(line);
        }
        for(int i = 0; i<pathList.count();i++) {
            if(pathList.at(i).contains(remoteName))
            pathList.removeAt(i);
        }
        LircPathFile.close();
        LircPathFile.open(QIODevice::WriteOnly | QIODevice::Text);
        inout.reset();
        for(int i= 0; i< pathList.count();i++) {
            inout << pathList.at(i)+"\n";
        }
        LircPathFile.close();
    }
    else
    {
         QMessageBox::warning(this,"Can't remove Lirc config file","Config file is used by " +remoteUsingLircConf,
                                         QMessageBox::NoButton,QMessageBox::NoButton);
    }
}

void CommandChainDlg::on_downloadRemoteButton_clicked()
{
    DownloadRemoteDlg *dloadRmDlg = new DownloadRemoteDlg(this, false);
    dloadRmDlg->exec();
    delete dloadRmDlg;
    QDir *dir = new QDir("/home/user/MyDocs/qtirreco/Devices/");
    models = dir->entryList(QDir::NoDotAndDotDot | QDir::Files, QDir::Name);
    m_ui->remoteListWidget->clear();
    m_ui->commandlistWidget->clear();
    m_ui->remoteListWidget->addItems(models);
    m_ui->remoteListWidget->sortItems(Qt::AscendingOrder);
    m_ui->deleteRemoteButton->setDisabled(true);
}

void CommandChainDlg::read_line(QString line, int readIndex)
{
    if(line.contains("LircConfs:", Qt::CaseInsensitive))
    {
        if(line.contains(remoteName, Qt::CaseInsensitive))
        {
            confFileInUse = true;
            remoteUsingLircConf = lircConfs.at(readIndex);
            remoteUsingLircConf.chop(5);
        }
        else confFileInUse = false;
    }
}
