#include "lircsocket.h"

LircSocket::LircSocket(QWidget *parent)
{
        n=0;
        fd=-1;
        setConnected(false);
}

LircSocket::~LircSocket()
{
        int i;

        for(i=0;i<n;i++)
        {
                delete data[i];
        }
        if(n>0) delete data;
        if(fd!=-1) closeSocket();
}

void LircSocket::openSocket(char *name)
{
        int flags;

        fd=socket(AF_UNIX,SOCK_STREAM,0);
        if(fd==-1) {
            QWidget w;
            w.setWindowTitle("Could not open socket");
            w.show();
            exit(EXIT_FAILURE);
        }
        addr.sun_family=AF_UNIX;
        strcpy(addr.sun_path,name);

        if(!connectSocket()) {
            QWidget w;
            w.setWindowTitle("Could not connect to socket");
            w.show();

            exit(EXIT_FAILURE);
        }

        fcntl(fd,F_SETOWN,getpid());
        flags=fcntl(fd,F_GETFL,0);

        if(flags!=-1)
             fcntl(fd,F_SETFL,flags|O_NONBLOCK);

}

bool LircSocket::connectSocket()
{
        if(::connect(fd,(struct sockaddr *) &addr,sizeof(addr))==-1)
                return(false);
        setConnected(true);
        sn=new QSocketNotifier(fd,QSocketNotifier::Read,0);
        connect(sn,SIGNAL(activated(int)),
                this,SLOT(dataReceived()));
        return(true);
}

bool LircSocket::reconnectSocket()
{
        int flags;

        fd=socket(AF_UNIX,SOCK_STREAM,0);
        if(fd==-1)
                return(false);
        if(!connectSocket()) {
                close(fd);
                fd=-1;
                return(false);
        }
        fcntl(fd,F_SETOWN,getpid());
        flags=fcntl(fd,F_GETFL,0);
        if(flags!=-1)
                fcntl(fd,F_SETFL,flags|O_NONBLOCK);
        return(true);
}

void LircSocket::closeSocket()
{
        delete sn;
        shutdown(fd,2);
        close(fd);
        fd=-1;
        setConnected(false);
}

void LircSocket::sendSocket(const QString *action)
{
        const char *buffer;
        int done,todo;
        QString string;

        if(!isConnected()) return;

        string=*action+"\n";
        QByteArray foo = string.toAscii();
        buffer = foo.data();
        todo=string.length();

        while(todo>0) {
                done=write(fd,(void *) buffer,todo);
                if(done<0) {
                        if(errno==EPIPE) {
                                closeSocket();
                                emit disconnected(fd);
                        }
                        return;
                }
                buffer+=done;
                todo-=done;
        }
}

bool LircSocket::getPacket(const QString *a)
{
        const QString *string;
        int retry,data_n=0;
        enum packet_state state;

        message=QString::null;
        status=true;
        status_message=QString::null;

        for(int i=0;i<n;i++) {
                delete data[i];
        }
        if(n>0) delete data;
        n=0;
        retry=0;state=P_BEGIN;
        while(1) {
                if(retry>0) usleep(TIMEOUT_SLEEP);
                retry++;
                string=recSocket();
                if(!isConnected() ||
                   (!a && !string && state==P_BEGIN)) return(false);
                if(!string && retry>TIMEOUT) {
                        QWidget w;
                        w.setWindowTitle("Connection timed out");
                        w.show();
                        return(false);
                }
                else if(!string)
                        continue;
                retry=0;
                switch(state) {
                case P_BEGIN:
                        if(string->compare("BEGIN",Qt::CaseInsensitive)!=0) {
                                if(a) continue;
                                message=*string;
                                return(true);
                        }
                        state=P_MESSAGE;
                        break;
                case P_MESSAGE:
                        message=*string;
                        state=P_STATUS;
                        break;
                case P_STATUS:
                        status_message=*string;
                        if(string->compare("DATA",Qt::CaseInsensitive)!=0) {
                                status=true;
                                state=P_N;
                                break;
                        }
                        else if(string->compare("SUCCESS",Qt::CaseInsensitive)!=0)
                                status=true;
                        else if(string->compare("END",Qt::CaseInsensitive)!=0) {
                                status=true;
                                return(true);
                        }
                        else  status=false;
                        state=P_DATA;
                        break;
                case P_DATA:
                        if(string->compare("END",Qt::CaseInsensitive)==0) {
                                n=0;
                                return(true);
                        }
                        else if(string->compare("DATA",Qt::CaseInsensitive)==0) {
                                state=P_N;
                                break;
                        }
                        goto bad_packet;
                case P_N:
                        bool ok;

                        data_n=string->toInt(&ok);
                        if(!ok)
                                goto bad_packet;

                        if(data_n==0)
                                state=P_END;

                        else {
                                data=new QString *[data_n];
                                state=P_DATA_N;
                        }
                        break;
                case P_DATA_N:
                        data[n]=new QString(*string);
                        n++;
                        if(n==data_n) state=P_END;
                        break;
                case P_END:
                        if(string->compare("END",Qt::CaseInsensitive)==0) {
                                if(a) {
                                        if(a->compare(message,Qt::CaseInsensitive)!=0) {
                                                state=P_BEGIN;
                                                continue;
                                        }
                                }
                                return(true);
                        }
                        goto bad_packet;
                        break;
                }
        }
 bad_packet:
       /* QWidget w;
        w.setWindowTitle("Bad return packet");
        w.show(); */
        flushSocket();
        return(false);
}

const QString *LircSocket::recSocket(void)
{
        static char buffer[PACKET_SIZE+1]="";
        static QString qstring;
        char *end;
        static int ptr=0,end_len=0;
        ssize_t ret;

        if(!isConnected()) return(0);
        if(ptr>0) {
                memmove(buffer,buffer+ptr,strlen(buffer+ptr)+1);
                ptr=strlen(buffer);
                end=strchr(buffer,'\n');
        }
        else end=NULL;

        if(end==NULL) {
                ret=read(fd,buffer+ptr,PACKET_SIZE-ptr);

                if(ret<=0) {
                        if(ret==0) {
                                closeSocket();
                                emit disconnected(fd);
                        }
                        ptr=0;
                        return(0);
                }
                buffer[ptr+ret]=0;
        }
        end=strchr(buffer,'\n');
        if(end==NULL) /* bad packet */ {
                flushSocket();
                ptr=0;
                return(0);
        }
        end[0]=0;
        ptr=strlen(buffer)+1;
        qstring=buffer;
        return(&qstring);
}

void LircSocket::flushSocket(void)
{
        char *buffer[100];
        ssize_t ret;

        if(!isConnected()) return;

        while((ret=read(fd,buffer,100))>0);
        if(ret==0) {
                closeSocket();
                emit disconnected(fd);
        }
}

QString *LircSocket::getMessage(void)
{
        return(&message);
}

bool LircSocket::isConnected(void)
{
        return(connectState);
}

void LircSocket::setConnected(bool state)
{
        connectState=state;
}

bool LircSocket::getStatus(void)
{
        return(status);
}

int LircSocket::getN(void)
{
        return(n);
}

QString *LircSocket::getData(int i)
{
        return(data[i]);
}

const QString *LircSocket::getErrorString(void)
{
        e="";

        for(int i=0;i<n;i++) {
                e+=*getData(i);
                e+="\n";
        }
        return(&e);
}

void LircSocket::dataReceived()
{
        emit activated(fd);
        flushSocket();
}
