#ifndef LAYOUTWIDGET_H
#define LAYOUTWIDGET_H

#include <QtGui>
#include <QString>
#include <QWidget>
#include <QImage>
#include <QMainWindow>
#include <QPainter>
#include <QVector>
#include "buttonwidget.h"
#include "newbuttondlg.h"
#include "lircsocket.h"


class QDragEnterEvent;
class QDropEvent;
class ButtonWidget;

class LayoutWidget: public QWidget
{
    Q_OBJECT

public:
    //! Constructor.
    explicit LayoutWidget(QMainWindow *parent );
    //! Destructor.
    virtual ~LayoutWidget();
    //! Current background path.
    QString bgPath;
    //! Current background mode.
    QString backgroundMode;
    //! Selected button index in vector.
    int currentButtonIndex;
    //! Methods to add button to layout.
    void addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int aNumber);
    void addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, QPoint position, int timeOut);
    //! Sets using mode enabled or disabled.
    void setUseModeEnabled(bool useMode);
    //! Shows menu.
    void setButtonsVisible(bool menuButtonsVisible);
    //! Socket for sending Lirc commands.
    LircSocket *socket;
    //! Vector for all buttons on layout.
    QVector<ButtonWidget*> *vector;

private:
    //! Boolean to tell if using mode enabled or disabled.
    bool useModeEnabled;
    //! Boolean to tell if menu buttons visible.
    bool buttonsVisible;
    //! Background RGB values.
    QString r,g,b;
    //! Remote name for active remote.
    QString activeRemoteName;
    //! Count for buttons.
    int number;
    //! Copy of button used in drag/drop.
    ButtonWidget *newButton;
    //! Button position.
    int xPos,yPos;
    //! Timer for sending lirc commands in a row.
    QTimer *timer;
    //! Extra buttonwidget for sending lirc commands.
    ButtonWidget *copyButton;
    //! Timer timeout time.
    int timeout;
    //! Timer when multiple commands in one button.
    QTimer *timer2;
    //! Timer2 timeout time.
    int timeout2;
    //! Index of commandchain used by timer2.
    int timer2Index;

protected:
    void mousePressEvent(QMouseEvent *event);
    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dropEvent(QDropEvent *event);


signals:
    //! Emitted for QtIrreco to hide or show menu buttons.
    void showOrHideMenu();
    void saveFailed();

public slots:
    //! Saves remote to file.
    void saveRemoteToFile();
    //! Opens new button dialog.
    void openEditDlg();
    //! Opens new button dialog but used for editing existing button.
    void editButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number, int timeOut);
    //! Slot to change current background mode.
    void setBackgroundMode(QString mode);
    //! Slot to set RGB values and mode.
    void setRgbValues(QString red,QString green,QString blue);
    //! Slot to set active remote name.
    void setActiveRemoteName(QString activeRemote);
    //! Slot to set integer values of RGB.
    void setRgbInteger(int aR,int aG,int aB);
    //! Slot to set background image path.
    void setBackgroundImagePath(QString bgImagePath);
    //! Slot to clear LayoutWidget from buttons.
    void clearScreen();

private slots:
    //! Slot called when button pressed and it has command.
    void sendIrCommands(QStringList commands);
    //! Slot called when delete button in button menu clicked.
    void deleteButton();
    //! Timer slot.
    void sendIrCommandsSlot();
    //! Timer2 slot.
    void sendIrCommandsSlot2();
};
#endif // LAYOUTWIDGET_H
