#ifndef COMMANDCHAINDLG_H
#define COMMANDCHAINDLG_H

#include <QtGui/QDialog>
#include <QListWidgetItem>
#include <QDir>

#include "newbuttondlg.h"

#define DEVICE "/home/user/MyDocs/qtirreco/Devices/"

namespace Ui {
    class CommandChainDlg;
}

class CommandChainDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(CommandChainDlg)
public:
    //! Constructor.
    explicit CommandChainDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~CommandChainDlg();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::CommandChainDlg *m_ui;
    //! Pushbutton used for selecting wanted commands to commandchain.
    QPushButton *commandButton;
    //! Stringlist containing remote models on device.
    QStringList models;
    //! Boolean to help read remote commands.
    QString remoteName;
    bool confFileInUse;
    QStringList lircConfs;
    QString remoteUsingLircConf;

    bool flag;
    //! Boolean to help read remote raw_code commands.
    bool raw_flag;
    //! Stringlist containing remote commands.
    QStringList commands;
    //! Method for reading remote config file.
    void process_line(QString line);
    //! Method for reading remote config file for deleting.
    void read_line(QString line, int readIndex);


signals:
    //! Adds command to NewButtonDlg and closes this.
    void signalAddCommand(QString commandName,QString modelName, QString command);

private slots:
    //! Opens DownloadRemoteDlg.
    void on_downloadRemoteButton_clicked();
    //! Emits signalAddCommand with proper item values.
    void commandItemClicked(QListWidgetItem* item);
    //! Reads remote commands from file and adds pushbuttons to listwidget.
    void getCommands(QListWidgetItem* item);
    //! Removes remote file.
    void deleteRemote();
};
#endif // COMMANDCHAINDLG_H
