#ifndef BUTTONWIDGET_H
#define BUTTONWIDGET_H

#include <QtGui>
#include <QString>
#include <QWidget>
#include "layoutwidget.h"
#include <QTextStream>
#include <QFile>


class QPixmap;


class ButtonWidget : public QWidget
{
	Q_OBJECT
	
public:
        //! Constructor.
        explicit ButtonWidget(QWidget *parent, const QString aFileNameUnPressed, QString aFileNamePressed, QString aConfFileName,
                              QString aButtonText, QStringList commands, int time );
        //! Destructor.
        virtual ~ButtonWidget();
        //! Method for reading button config file.
        void process_line(QString line);
        //! Pressed pixmap to be drawn.
        QPixmap *pressedPixmap;
        //! Unpressed pixmap to be drawn.
        QPixmap *unpressedPixmap;
        //! Stringlist which has button commmands.
        QStringList commandChain;
        //! Unpressed file name.
        QString fileNameUnPressed;
        //! Pressed file name.
        QString fileNamePressed;
        //! Config file name.
        QString confFileName;
        //! Buttons text.
        QString buttonText;
        //! Boolean which tells if text is allowed with button.
        bool allowText;
        //! Font properties, using default font sans-serif if not defined.
        int textUpSize;
        int textUpWeight;
        QColor *textUpColor;
        QFont *textUpFont;

        int textDownSize;
        int textDownWeight;
        QColor *textDownColor;
        QFont *textDownFont;
        QString upFontFamily;
        QString downFontFamily;

        QString textPadding;
        int timeOut;

protected:
        //! Draws the  widget.
        void paintEvent( QPaintEvent* event);


private:
        //! Foreground value and font RGB values.
        int iU,rU,gU,bU;
        //! Method to check proper file for command.
        void checkButtonCommand();
};
#endif // BUTTONWIDGET_H
