#include "backgrounddlg.h"
#include "ui_backgrounddlg.h"

BackgroundDlg::BackgroundDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::BackgroundDlg)
{
    m_ui->setupUi(this);
    redString = "0";
    greenString = "0";
    blueString = "0";

    defaultImageSelected = true;
    bgMode = "default";

    pm = QPixmap(120,80);
    backgroundColor = (QColor(Qt::black));
    pm.fill(backgroundColor);

    QIcon colorDlgButtonIcon = QIcon(pm);
    m_ui->colorButton->setIconSize(QSize(25,25));
    m_ui->colorButton->setIcon(colorDlgButtonIcon);
    m_ui->background->setAutoFillBackground(false);
    m_ui->background->setPixmap(QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO)));
    m_ui->background->setScaledContents(true);
    m_ui->background->setAlignment(Qt::AlignLeading|Qt::AlignLeft|Qt::AlignTop);
    backgroundPixmap = QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
    loadThemes();

    connect(m_ui->tabWidget,SIGNAL(currentChanged(int)),this,SLOT(activateTab(int)));
    connect(m_ui->listWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setBackgroundsOnListWidget2()));
    connect(m_ui->listWidget_2,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setBackgroundOnPreviewLabel()));
}

BackgroundDlg::~BackgroundDlg()
{
    delete m_ui;
}

void BackgroundDlg::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BackgroundDlg::on_okButton_clicked()
{
    emit backgroundChanged(bgMode);
    this->close();
}

QPixmap BackgroundDlg::returnBackgroundPixmap()
{
    return backgroundPixmap;
}

QPixmap BackgroundDlg::returnBackgroundPixmapColor()
{
    return pm;
}

bool BackgroundDlg::isDefaultImageSelected()
{
    return defaultImageSelected;
}

void BackgroundDlg::setBackgroundColor(const QColor bgc)
{
    backgroundColor = bgc;
}

void BackgroundDlg::rgbFromColorDlg(const QString red,const QString green,const QString blue)
{
    redString = red;
    greenString = green;
    blueString = blue;
}

void BackgroundDlg::on_defaultImageButton_clicked()
{
    bgMode = "default";
    defaultImageSelected = true;
    m_ui->background->clear();
    m_ui->background->setAutoFillBackground(false);
    m_ui->defaultImageButton->setChecked(true);
    m_ui->background->setPixmap(QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO)));
    backgroundPixmap = QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO));
}

void BackgroundDlg::on_colorButton_clicked()
{
    QPalette palette;
    colorDlg = new BackgroundColorDlg(this);
    connect(colorDlg,SIGNAL(selectClicked(QColor)),this,SLOT(setBackgroundColor(QColor)));
    connect(colorDlg,SIGNAL(rgbValues(QString,QString,QString)),this,SLOT(rgbFromColorDlg(QString,QString,QString)));
    colorDlg->exec();

    pm.fill(backgroundColor);
    QIcon colorDlgButtonIcon = QIcon(pm);
    m_ui->colorButton->setIcon(colorDlgButtonIcon);

    palette.setBrush(QPalette::Window, pm);
    m_ui->background->setPalette(palette);
    m_ui->background->setAutoFillBackground(true);
    backgroundPixmap = pm;

   // this->activateWindow();
    bgMode = "color_only";
    defaultImageSelected = false;
    m_ui->background->clear();
    m_ui->colorButton->setChecked(true);
    m_ui->background->setAutoFillBackground(true);
    palette.setBrush(QPalette::Window, pm);
    m_ui->background->setPalette(palette);
    backgroundPixmap = pm;
    emit rgbToLw(redString, greenString, blueString);

}

QString BackgroundDlg::returnBackgroundImagePath()
{
    return backgroundImagePath;
}

void BackgroundDlg::on_imageButton_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open Image"), "/home/user/MyDocs/qtirreco/themes/", tr("Image Files (*.png *.jpg *.bmp)"));
    QTextStream inputStream(&fileName);
    QString bgImagePath;
    while (!inputStream.atEnd()) {
         inputStream >> bgImagePath;
         if (!bgImagePath.isEmpty()) {
              defaultImageSelected = false;
              QPixmap pix(bgImagePath);

              m_ui->background->setPixmap(pix);
              backgroundPixmap = pix.scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
         }
    }
    backgroundImagePath = bgImagePath;
    bgMode = "image";
    defaultImageSelected = false;
}

void BackgroundDlg::activateTab(const int tabIndex)
{
    if (tabIndex == 1) {
        bgMode = "default";
        defaultImageSelected = true;
        m_ui->background->clear();
        m_ui->background->setAutoFillBackground(false);
        m_ui->defaultImageButton->setChecked(true);
        m_ui->background->setPixmap(QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO)));
        backgroundPixmap = QPixmap(QString::fromUtf8(DEVICEDEFAULTLOGO));
    }
}

void BackgroundDlg::loadThemes()
{
    QDir *themeDirs = new QDir(DEVICETHEMES);

    themeDirList = themeDirs->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);

    for(int i = 0 ; i < themeDirList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();

        QString themeConf = DEVICETHEMES + themeDirList.at(i) + "/theme.conf";
        // Check if theme has any background directories.
        QDir *themeBgDirs = new QDir(DEVICETHEMES + themeDirList.at(i) + "/bg/");
        QStringList themeBgs = themeBgDirs->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        if(!themeBgs.isEmpty()) {
            QFile file(themeConf);
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
                 QMessageBox::warning(this,"Error with theme config","Failed to load theme name from config",
                         QMessageBox::NoButton,QMessageBox::NoButton);
                return;
            }

            QTextStream in(&file);
            while (!in.atEnd()) {
                QString line = in.readLine();
                process_line(line, THEME);
            }

            item->setText(themeName);

            m_ui->listWidget->insertItem(i, item);
            m_ui->listWidget->show();
        }
        else {
                themeDirList.removeAt(i);
                i--;
             }
    }
}
void BackgroundDlg::setBackgroundsOnListWidget2()
{
    m_ui->backgroundPreview->clear();
    m_ui->listWidget_2->clear();

    currentIndex = m_ui->listWidget->currentRow();
    QDir *backgroundDirs = new QDir(DEVICETHEMES + themeDirList.at(currentIndex) +"/bg/");
    backgroundList = backgroundDirs->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);

    for(int i = 0 ; i < backgroundList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();

        QString bgConf = DEVICETHEMES + themeDirList.at(currentIndex) + "/bg/" + backgroundList.at(i) +"/bg.conf";
        QFile file(bgConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with background config","Failed to load background name from config",
                     QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }
        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line, BACKGROUND);
        }

        item->setText(backgroundName);

        m_ui->listWidget_2->insertItem(i, item);
        m_ui->listWidget_2->show();
    }
}

void BackgroundDlg::setBackgroundOnPreviewLabel()
{
    bgMode = "theme";
    defaultImageSelected = false;

    QPixmap bgPreview(128,128);
    QString string(DEVICETHEMES + themeDirList.at(currentIndex) +"/bg/"  + backgroundList.at(m_ui->listWidget_2->currentRow()) +"/image.png");
    bgPreview.load(string);
    backgroundImagePath = string;
    bgPreview = bgPreview.scaled(321,151,Qt::KeepAspectRatio,Qt::FastTransformation);
    m_ui->backgroundPreview->setPixmap(bgPreview);
    backgroundPixmap = bgPreview.scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);
}

void BackgroundDlg::process_line(QString line, const int CONF_TYPE)
{
    switch(CONF_TYPE)
    {
        case THEME:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                themeName = line.remove(0,5);
            break;
        case BACKGROUND:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                backgroundName = line.remove(0,5);
            break;
    }
}
