#include "backgroundcolordlg.h"
#include "ui_backgroundcolordlg.h"

BackgroundColorDlg::BackgroundColorDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::BackgroundColorDlg)
{
    m_ui->setupUi(this);
    this->setWindowTitle("Select Background Color");
    this->setPreviewPalette();

    connect(m_ui->redScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
    connect(m_ui->greenScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
    connect(m_ui->blueScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
}

BackgroundColorDlg::~BackgroundColorDlg()
{
    delete m_ui;
}

void BackgroundColorDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BackgroundColorDlg::setPreviewPalette()
{
    QPixmap pm = QPixmap(m_ui->previewLabel->width(),m_ui->previewLabel->height());
    pm.fill(QColor(m_ui->redScrollBar->value(), m_ui->greenScrollBar->value(), m_ui->blueScrollBar->value()));

    m_ui->previewLabel->setPixmap(pm);
}

void BackgroundColorDlg::on_selectColorButton_clicked()
{
    emit selectClicked(QColor(m_ui->redScrollBar->value(), m_ui->greenScrollBar->value(), m_ui->blueScrollBar->value()));
    QString r;
    r.setNum(m_ui->redScrollBar->value(),10);
    QString g;
    g.setNum(m_ui->greenScrollBar->value(),10);
    QString b;
    b.setNum(m_ui->blueScrollBar->value(),10);
    emit rgbValues(r, g, b);
    this->close();
}
