#ifndef RENAMEREMOTEDLG_H
#define RENAMEREMOTEDLG_H

#include <QtGui/QDialog>

namespace Ui {
    class RenameRemoteDlg;
}

class RenameRemoteDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(RenameRemoteDlg)
public:
    //! Constructor.
    explicit RenameRemoteDlg(QWidget *parent = 0, QString remoteName = "");
    //! Destructor.
    virtual ~RenameRemoteDlg();
    //! Methods for outer class usage.
    void setNameLabelText(QString text);
    void setPushButtonText(QString text);
    void setLabelGeometry(int x,int y,int width,int height);
    void setPushButtonGeometry(int x,int y,int width,int height);
    void hideLineEdit();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::RenameRemoteDlg *m_ui;

private slots:
    void on_changeNameButton_clicked();
signals:
    //! Signal to change current remotes name in files.
    void changeName(QString newRemoteName);
    //! Signal to create a new remote.
    void newRemote(QString remoteName);
    //! Signal to delete current remote.
    void deleteRemote();
};
#endif // RENAMEREMOTEDLG_H
