#include "buttonselectdlg.h"
#include "ui_buttonselectdlg.h"

ButtonSelectDlg::ButtonSelectDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::ButtonSelectDlg)
{
    m_ui->setupUi(this);
    this->setWindowTitle("Select button image");
    m_ui->selectPushButton->setDisabled(true);
    loadThemes();
    defaultflag = false;
}

ButtonSelectDlg::~ButtonSelectDlg()
{
    delete m_ui;
}

void ButtonSelectDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ButtonSelectDlg::loadThemes()
{
    themeDirList.clear();
    QDir *themeDirs = new QDir(DEVICETHEMES);

    themeDirList = themeDirs->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
    themeDirList.insert(0,"default");

    for(int i = 0 ; i < themeDirList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();
        QString themeConf;

        if(themeDirList.at(i) == "default")
            themeConf = "/home/user/.qtirreco/themes/default/theme.conf";

        else  themeConf = DEVICETHEMES + themeDirList.at(i) + "/theme.conf";

        QFile file(themeConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with theme config","Couldn't load theme config file!",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }

        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line, THEME);
        }
        item->setText(themeName);

        m_ui->HWlistWidget->insertItem(i, item);
        m_ui->HWlistWidget->show();
    }

    connect(m_ui->HWlistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setBackgroundsOnListWidget2(QListWidgetItem*)));
}

void ButtonSelectDlg::setBackgroundsOnListWidget2(QListWidgetItem *item)
{
    buttonDirList.clear();
    m_ui->label->clear();
    themeIndex = m_ui->HWlistWidget->currentRow();

    m_ui->HWbuttonListWidget->clear();

    if(item->text() == "Default") {
        QDir *currentThemeDir = new QDir("/home/user/.qtirreco/themes/default/buttons/");
        buttonDirList = currentThemeDir->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        defaultflag = true;
    }
    else {
        QDir *currentThemeDir = new QDir(DEVICETHEMES + themeDirList.at(themeIndex) +"/buttons/");
        buttonDirList = currentThemeDir->entryList(QDir::NoDotAndDotDot | QDir::Dirs, QDir::Name);
        defaultflag = false;
    }

    for(int i = 0 ; i < buttonDirList.count() ; i++) {
        QListWidgetItem *item = new QListWidgetItem();
        QString buttonConf;

        if(defaultflag)
            buttonConf = "/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(i) + "/button.conf";

        else buttonConf = DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(i) + "/button.conf";

        QFile file(buttonConf);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QMessageBox::warning(this,"Error with button config","Couldn't load button config file!",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
            return;
        }

        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            process_line(line, BUTTON);
        }
        file.close();
        if(defaultflag) {
            QIcon icon("/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(i) + "/" + upButtonName);
            item->setIcon(icon);
            item->setText(buttonName);
        }
        else {
            QIcon icon(DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(i) + "/" + upButtonName);
            item->setIcon(icon);
            item->setText(buttonName);
        }

        m_ui->HWbuttonListWidget->insertItem(i, item);
        m_ui->HWbuttonListWidget->show();
    }
    connect(m_ui->HWbuttonListWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(setButton()));
}

void ButtonSelectDlg::setButton()
{
    buttonIndex = m_ui->HWbuttonListWidget->currentRow();
    if(defaultflag) { QPixmap pix("/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        m_ui->label->setPixmap(pix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
        m_ui->label->setAlignment(Qt::AlignCenter);
        m_ui->selectPushButton->setEnabled(true);
    }
    else { QPixmap pix(DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        m_ui->label->setPixmap(pix.scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
        m_ui->label->setAlignment(Qt::AlignCenter);
        m_ui->selectPushButton->setEnabled(true);
    }
}

void ButtonSelectDlg::on_selectPushButton_clicked()
{
    QString fileNameUnPressed;
    QString fileNamePressed;
    QString confFileName;

    if(defaultflag) {
        fileNameUnPressed = ("/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        fileNamePressed = ("/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(buttonIndex) + "/" + downButtonName);
        confFileName = ("/home/user/.qtirreco/themes/default/buttons/" + buttonDirList.at(buttonIndex) + "/button.conf");
    }
    else if(!defaultflag)
    {
        fileNameUnPressed = (DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + upButtonName);
        fileNamePressed = (DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/" + downButtonName);
        confFileName = (DEVICETHEMES + themeDirList.at(themeIndex) + "/buttons/" + buttonDirList.at(buttonIndex) + "/button.conf");
    }
    emit signalAddButton(fileNameUnPressed, fileNamePressed, confFileName);
    this->close();
}

void ButtonSelectDlg::process_line(QString line, int CONF_TYPE)
{
    switch(CONF_TYPE) {
        case THEME:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                themeName = line.remove(0,5);
            break;

        case BUTTON:
            if(line.contains("name=", Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive))
                buttonName = line.remove(0,5);
            if(line.contains("up=", Qt::CaseInsensitive) && line.startsWith("u", Qt::CaseInsensitive))
                upButtonName = line.remove(0,3);
            if(line.contains("down=", Qt::CaseInsensitive) && line.startsWith("d", Qt::CaseInsensitive))
                downButtonName = line.remove(0,5);
            break;
    }
}
