#ifndef BACKGROUNDDLG_H
#define BACKGROUNDDLG_H

#include <QtGui/QDialog>
#include <QFile>
#include <QFileDialog>
#include <QTextStream>
#include <QColorDialog>
#include <QIcon>
#include <QListWidgetItem>
#include <QMessageBox>
#include "backgroundcolordlg.h"

#define THEME 0
#define BACKGROUND 1

#define DEVICEDEFAULTLOGO "/home/user/.qtirreco/themes/default/bg/qtirreco/irreco_logo.png"
#define DEVICETHEMES "/home/user/MyDocs/qtirreco/themes/"

namespace Ui {
    class BackgroundDlg;
}

class BackgroundDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(BackgroundDlg)
public:
    //! Constructor.
    explicit BackgroundDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~BackgroundDlg();
    //! Variable for background pixmap which is returned to QtIrreco class.
    QPixmap backgroundPixmap;
    //! Method for returning pixmap which is filled with color.
    QPixmap returnBackgroundPixmapColor();
    //! Method for returning pixmap which is filled with selected image or default image.
    QPixmap returnBackgroundPixmap();
    //! Method which return boolean if default image is selected.
    bool isDefaultImageSelected();
    //! Variable for backgrounds name.
    QString backgroundImagePath;
    //! Method for returning backgrounds name.
    QString returnBackgroundImagePath();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::BackgroundDlg *m_ui;
    //! Pixmap used for preview label.
    QPixmap pm;
    //! Variable for background color.
    QColor backgroundColor;
    //! Object for color dialog.
    BackgroundColorDlg *colorDlg;
    //! Boolean for telling if default image is selected.
    bool defaultImageSelected;
    //! Selected index in theme listwidget.
    int currentIndex;
    //! Background name from conf file.
    QString backgroundName;
    //! Theme name from conf file.
    QString themeName;
    //! List of all theme directories.
    QStringList themeDirList;
    //! List of background in selected theme.
    QStringList backgroundList;
    //! Selected background mode: default, theme, color_only or image.
    QString bgMode;
    //! Variables for RGB values in string format.
    QString redString, greenString, blueString;
    //! Method for reading lines in theme and background config.
    void process_line(QString line, const int CONF_TYPE);
    //! Method for loading existing themes to listwidget.
    void loadThemes();

private slots:
    //! Opens filedialog for selecting background image.
    void on_imageButton_clicked();
    //! Opens color dialog for selecting background color.
    void on_colorButton_clicked();
    //! Sets image to default.
    void on_defaultImageButton_clicked();
    //! Emits some signals to QtIrreco class.
    void on_okButton_clicked();
    //! Slot for setting background names on listwidget.
    void setBackgroundsOnListWidget2();
    //! Slot for setting background pixmap to preview label.
    void setBackgroundOnPreviewLabel();
    //! Slot which is called when tab is changed.
    void activateTab(const int tabIndex);
    //! Sets backgroundcolor variable.
    void setBackgroundColor(const QColor bgc);
    //! Sets RGB values and emits them to LayoutWidget class.
    void rgbFromColorDlg(const QString red,const QString green,const QString blue);

signals:
    //! Signals which emits RGB values and background mode
    void rgbToLw(QString red,QString green,QString blue);
    //! Signal that mode changed.
    void backgroundChanged(QString bgMode);
};
#endif // BACKGROUNDDLG_H
