#ifndef LIRCSOCKET_H
#define LIRCSOCKET_H

#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <iostream>
#include <qglobal.h>
#include <qsocketnotifier.h>
#include <QMessageBox>

#define PACKET_SIZE 256
#define TIMEOUT 100 /* 1 sec */
#define TIMEOUT_SLEEP 10000 /* 1 sec */

class LircSocket : public QObject {
    Q_OBJECT

public:
        explicit LircSocket(QWidget *parent);
        virtual ~LircSocket();
        void openSocket(char *name);
        bool connectSocket(void);
        bool reconnectSocket(void);
        void closeSocket(void);
        void sendSocket(const QString *action);
        bool getPacket(const QString *a=0);
        const QString *recSocket(void);
        void flushSocket(void);
        QString *getMessage(void);
        bool isConnected(void);
        void setConnected(bool state);
        bool getStatus(void);
        int getN(void);
        QString *getData(int i);
        const QString *getErrorString(void);

        enum packet_state
        {
                P_BEGIN,
                P_MESSAGE,
                P_STATUS,
                P_DATA,
                P_N,
                P_DATA_N,
                P_END
        };

signals:
        void activated(int);
        void disconnected(int);

private slots:
        void dataReceived(void);

private:
        int fd;
        bool connectState;
        struct sockaddr_un addr;
        QSocketNotifier *sn;

        QString message;
        bool status;
        QString status_message;
        int n;
        QString **data;
        QString e;
};
#endif // LIRCSOCKET_H
