#include "themecreatordlg.h"
#include "ui_themecreatordlg.h"

ThemeCreatorDlg::ThemeCreatorDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::ThemeCreatorDlg)
{
    m_ui->setupUi(this);
    m_ui->saveThemePushButton->setDisabled(true);
    m_ui->editButton->setDisabled(true);
    m_ui->deleteButton->setDisabled(true);
    this->setWindowTitle("Create a theme");
    connect(m_ui->tabWidget,SIGNAL(currentChanged(int)),this,SLOT(activateTab(int)));
    connect(m_ui->lineEdit,SIGNAL(textChanged(QString)),this,SLOT(allowSaving()));
    connect(m_ui->lineEdit_2,SIGNAL(textChanged(QString)),this,SLOT(allowSaving()));
    connect(m_ui->textEdit,SIGNAL(textChanged()),this,SLOT(allowSaving()));
    buttons = new QVector<ThemeCreatorButton*>();
    backgrounds = new QVector<ThemeCreatorBackground*>();
    buttonHeight = 0;
    backgroundHeight = 0;
    tabIndex = 0;
    activateTab(tabIndex);
    num = 0;
}
ThemeCreatorDlg::~ThemeCreatorDlg()
{
    for(int i=0;i<buttons->count();i++)
        buttons->at(i)->deleteLater();

    for(int i=0;i<backgrounds->count();i++)
        backgrounds->at(i)->deleteLater();

    delete buttons;
    delete backgrounds;
    delete m_ui;
}
void ThemeCreatorDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void ThemeCreatorDlg::on_addButton_clicked()
{
    if(tabIndex == 1) {
        CreateButtonDlg *createButton = new CreateButtonDlg(this,buttons);
        connect(createButton,SIGNAL(createButton(QString,QPixmap,QPixmap,QFont,QFont,bool,QString,QString)),this,SLOT(createButton(QString,QPixmap,QPixmap,QFont,QFont,bool,QString,QString )));
        connect(createButton,SIGNAL(createButton(QString,QPixmap,QPixmap,QFont,QFont,bool,QString,QString)),createButton,SLOT(deleteLater()));
        createButton->exec();
    }
    if(tabIndex == 2) {
        CreateBackgroundDlg *createBackground = new CreateBackgroundDlg(this,backgrounds);
        connect(createBackground,SIGNAL(createBackground(QString,QPixmap,QString)),this,SLOT(createBackground(QString,QPixmap,QString)));
        connect(createBackground,SIGNAL(createBackground(QString,QPixmap,QString)),createBackground,SLOT(deleteLater()));
        createBackground->exec();
    }
}
void ThemeCreatorDlg::createButton(QString buttonName, QPixmap pressedPix,QPixmap unpressedPix,QFont pressedFont,
                                   QFont unpressedFont,bool textEnabled,QString pressedPath,QString unpressedPath)
{
    newButton = new ThemeCreatorButton(m_ui->scrollAreaWidgetContents);
    newButton->setGeometry(0,buttonHeight,m_ui->scrollAreaWidgetContents->width(),104);
    newButton->buttonName = buttonName;
    newButton->pressedPix = pressedPix;
    newButton->unpressedPix = unpressedPix;
    newButton->pressedFont = pressedFont;
    newButton->unpressedFont = unpressedFont;
    newButton->enableFont = textEnabled;
    newButton->pressedPath = pressedPath;
    newButton->unpressedPath = unpressedPath;
    newButton->createLabels(newButton->buttonName,newButton->pressedPix,newButton->unpressedPix);
    newButton->show();
    buttons->append(newButton);
    buttonHeight += 104;
    m_ui->scrollAreaWidgetContents->setMinimumHeight(8+buttonHeight);
    if(buttons->count() == 1) {
        m_ui->pictureLabel->setPixmap(buttons->at(0)->unpressedPix.scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation));
        previewPath = buttons->at(0)->unpressedPath;
        preview_button = buttons->at(0)->buttonName;
    }
    allowSaving();
}
void ThemeCreatorDlg::activateTab(int index)
{
    tabIndex = index;
    m_ui->editButton->setDisabled(true);
    m_ui->deleteButton->setDisabled(true);
    for(int i=0;i<buttons->count();i++)
        buttons->at(i)->setAutoFillBackground(false);

    for(int i=0;i<backgrounds->count();i++)
        backgrounds->at(i)->setAutoFillBackground(false);

    if(tabIndex == 0) {
        m_ui->saveThemePushButton->move(320,320);
        m_ui->addButton->hide();
        m_ui->deleteButton->hide();
        m_ui->editButton->hide();
    }
    if(tabIndex == 1 || tabIndex == 2) {
        m_ui->saveThemePushButton->move(70,320);
        m_ui->addButton->show();
        m_ui->deleteButton->show();
        m_ui->editButton->show();
    }
}
void ThemeCreatorDlg::mousePressEvent(QMouseEvent *event)
{
    if(m_ui->tabWidget->currentIndex() == 0) {
        if(event->pos().x() >= m_ui->pictureLabel->pos().x() && event->pos().x() <= m_ui->pictureLabel->pos().x() + m_ui->pictureLabel->width()
        && event->pos().y() >= m_ui->pictureLabel->pos().y() && event->pos().y() <= m_ui->pictureLabel->pos().y() + m_ui->pictureLabel->height()
        && !buttons->isEmpty()) {
            ThemePreviewButtonDlg *preview = new ThemePreviewButtonDlg(this,buttons);
            connect(preview,SIGNAL(setPreviewButton(QString,QString)),this,SLOT(setPreviewPicture(QString,QString)));
            preview->exec();
            delete preview;
        }
    }
    if(m_ui->tabWidget->currentIndex() == 1) {
        if(m_ui->scrollAreaWidgetContents->underMouse()) {
            for(int j=0;j<buttons->count();j++)
                    buttons->at(j)->setAutoFillBackground(false);

            for(int i=0;i<buttons->count();i++) {
                m_ui->editButton->setDisabled(true);
                m_ui->deleteButton->setDisabled(true);
                if(buttons->at(i)->underMouse()) {
                    m_ui->editButton->setEnabled(true);
                    m_ui->deleteButton->setEnabled(true);
                    currentButtonIndex = i;
                    buttons->at(i)->setAutoFillBackground(true);
                    QPalette palette;
                    palette.setBrush(QPalette::Window,QColor(Qt::cyan));
                    buttons->at(i)->setPalette(palette);
                }
            }
        }
    }
    if(m_ui->tabWidget->currentIndex() == 2) {

        if(m_ui->scrollAreaWidgetContents_2->underMouse()) {
            for(int j=0;j<backgrounds->count();j++)
                    backgrounds->at(j)->setAutoFillBackground(false);

            for(int i=0;i<backgrounds->count();i++) {
                m_ui->editButton->setDisabled(true);
                m_ui->deleteButton->setDisabled(true);
                if(backgrounds->at(i)->underMouse()) {
                    m_ui->editButton->setEnabled(true);
                    m_ui->deleteButton->setEnabled(true);
                    currentBackgroundIndex = i;
                    backgrounds->at(i)->setAutoFillBackground(true);
                    QPalette palette;
                    palette.setBrush(QPalette::Window,QColor(Qt::cyan));
                    backgrounds->at(i)->setPalette(palette);
                }
            }
         }
    }
}
void ThemeCreatorDlg::setPreviewPicture(QString picturePath,QString buttonName)
{
    previewPath = picturePath;
    QPixmap pix(picturePath);
    pix = pix.scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation);
    m_ui->pictureLabel->setPixmap(pix);
    preview_button = buttonName;
}
void ThemeCreatorDlg::createBackground(QString name, QPixmap background,QString fileName)
{
    newBackground = new ThemeCreatorBackground(m_ui->scrollAreaWidgetContents_2);
    newBackground->setGeometry(0,backgroundHeight,m_ui->scrollAreaWidgetContents_2->width(),160);
    newBackground->name = name;
    newBackground->background = background;
    newBackground->picturePath = fileName;
    newBackground->createLabels(newBackground->name,newBackground->background);
    newBackground->show();
    backgrounds->append(newBackground);
    backgroundHeight += 170;
    m_ui->scrollAreaWidgetContents_2->setMinimumHeight(10+backgroundHeight);
    allowSaving();
}
void ThemeCreatorDlg::on_editButton_clicked()
{
    if(m_ui->tabWidget->currentIndex() == 1) {
        CreateButtonDlg *cbDlg = new CreateButtonDlg(this,buttons->at(currentButtonIndex),buttons);
        cbDlg->setAddButtonText("OK");
        connect(cbDlg,SIGNAL(createButton(QString,QPixmap,QPixmap,QFont,QFont,bool,QString,QString)),
                this,SLOT(editButton(QString,QPixmap,QPixmap,QFont,QFont,bool,QString,QString)));
        cbDlg->exec();
        delete cbDlg;
    }
    if(m_ui->tabWidget->currentIndex() == 2) {
        CreateBackgroundDlg *bgDlg = new CreateBackgroundDlg(this,backgrounds->at(currentBackgroundIndex),backgrounds);
        bgDlg->setAddButtonText("OK");
        connect(bgDlg,SIGNAL(createBackground(QString,QPixmap,QString)),this,SLOT(editBackground(QString,QPixmap,QString)));
        bgDlg->exec();
        delete bgDlg;
    }
}
void ThemeCreatorDlg::editButton(QString buttonName, QPixmap pressedPix,QPixmap unpressedPix,QFont pressedFont,QFont unpressedFont,
                                 bool textEnabled,QString pressedPath,QString unpressedPath)
{
    buttons->at(currentButtonIndex)->buttonName = buttonName;
    buttons->at(currentButtonIndex)->pressedPix = pressedPix;
    buttons->at(currentButtonIndex)->unpressedPix = unpressedPix;
    buttons->at(currentButtonIndex)->pressedFont = pressedFont;
    buttons->at(currentButtonIndex)->unpressedFont = unpressedFont;
    buttons->at(currentButtonIndex)->enableFont = textEnabled;
    buttons->at(currentButtonIndex)->pressedPath = pressedPath;
    buttons->at(currentButtonIndex)->unpressedPath = unpressedPath;
    buttons->at(currentButtonIndex)->deleteLabels();
    buttons->at(currentButtonIndex)->createLabels(buttonName,pressedPix,unpressedPix);
    buttons->at(currentButtonIndex)->update(buttons->at(currentButtonIndex)->rect());
    buttons->at(currentButtonIndex)->show();
    if(buttons->count() == 1) {
        m_ui->pictureLabel->setPixmap(buttons->at(0)->unpressedPix.scaled(128,128,Qt::IgnoreAspectRatio,Qt::FastTransformation));
        previewPath = buttons->at(0)->unpressedPath;
        preview_button = buttons->at(0)->buttonName;
    }
}
void ThemeCreatorDlg::editBackground(QString backgroundName, QPixmap background,QString fileName)
{
    backgrounds->at(currentBackgroundIndex)->name = backgroundName;
    backgrounds->at(currentBackgroundIndex)->background = background;
    backgrounds->at(currentBackgroundIndex)->picturePath = fileName;
    backgrounds->at(currentBackgroundIndex)->deleteLabels();
    backgrounds->at(currentBackgroundIndex)->createLabels(backgroundName,background);
    backgrounds->at(currentBackgroundIndex)->update(backgrounds->at(currentBackgroundIndex)->rect());
    backgrounds->at(currentBackgroundIndex)->show();
}
void ThemeCreatorDlg::on_deleteButton_clicked()
{
    if(m_ui->tabWidget->currentIndex() == 1) {
        buttons->at(currentButtonIndex)->deleteLater();
        buttons->remove(currentButtonIndex);
        m_ui->editButton->setDisabled(true);
        m_ui->deleteButton->setDisabled(true);
        buttonHeight -= 104;
        m_ui->scrollAreaWidgetContents->setMinimumHeight(8+buttonHeight);
        for(int i=currentButtonIndex;i<buttons->count();i++) {
            int posY = buttons->at(i)->y();
            buttons->at(i)->move(0,posY-104);
        }
    }
    if(m_ui->tabWidget->currentIndex() == 2) {
        backgrounds->at(currentBackgroundIndex)->deleteLater();
        backgrounds->remove(currentBackgroundIndex);
        m_ui->editButton->setDisabled(true);
        m_ui->deleteButton->setDisabled(true);
        backgroundHeight -= 170;
        m_ui->scrollAreaWidgetContents_2->setMinimumHeight(10+backgroundHeight);
        for(int i=currentBackgroundIndex;i<backgrounds->count();i++) {
            int posY = backgrounds->at(i)->y();
            backgrounds->at(i)->move(0,posY-170);
        }
    }
    allowSaving();
}
void ThemeCreatorDlg::allowSaving()
{
    if(m_ui->lineEdit->text() != "" && m_ui->lineEdit_2->text() != "" && buttons->count() > 0)
        m_ui->saveThemePushButton->setEnabled(true);

    else m_ui->saveThemePushButton->setDisabled(true);
}
void ThemeCreatorDlg::on_saveThemePushButton_clicked()
{
    QString theme = m_ui->lineEdit_2->text().toLower();
    for(int i=0; i<theme.count(); i++) {
        if(theme.at(i).isSpace())
            theme.remove(i,1);
    }
    QDir dir;
    if(!dir.exists("/home/user/MyDocs/qtirreco/themes/" + theme)) {
        dir.mkpath("/home/user/MyDocs/qtirreco/themes/" + theme);
        dir.mkdir("/home/user/MyDocs/qtirreco/themes/" + theme + "/bg");
        dir.mkdir("/home/user/MyDocs/qtirreco/themes/" + theme + "/buttons");
        for(int i=0;i<backgrounds->count();i++) {
           // Copy background images to proper path
           dir.mkdir("/home/user/MyDocs/qtirreco/themes/" + theme + "/bg/" + backgrounds->at(i)->name.toLower());
           QFile bgFile(backgrounds->at(i)->picturePath);
           bgFile.copy("/home/user/MyDocs/qtirreco/themes/" + theme + "/bg/" + backgrounds->at(i)->name.toLower() + "/image.png");
           bgFile.close();
           // bg.conf files
           QFile bgConf("/home/user/MyDocs/qtirreco/themes/" + theme + "/bg/" + backgrounds->at(i)->name.toLower() + "/bg.conf");
           if (!bgConf.open(QIODevice::ReadWrite | QIODevice::Text))
           return;
           QTextStream in(&bgConf);
           in << "[theme-bg]\n";
           in << "name=" + backgrounds->at(i)->name +"\n";
           in << "image=image.png";
           bgConf.close();
        }
        for(int i=0;i<buttons->count();i++) {
           // Copy button images to proper path
           dir.mkdir("/home/user/MyDocs/qtirreco/themes/" + theme + "/buttons/" + buttons->at(i)->buttonName.toLower());
           QFile upFile(buttons->at(i)->unpressedPath);
           QFile downFile(buttons->at(i)->pressedPath);
           upFile.copy("/home/user/MyDocs/qtirreco/themes/" + theme + "/buttons/" + buttons->at(i)->buttonName.toLower() +"/unpressed.png");
           downFile.copy("/home/user/MyDocs/qtirreco/themes/" + theme + "/buttons/" + buttons->at(i)->buttonName.toLower() +"/pressed.png");
           upFile.close();
           downFile.close();
           // button.conf files
           QFile buttonConf("/home/user/MyDocs/qtirreco/themes/" + theme + "/buttons/" + buttons->at(i)->buttonName.toLower() + "/button.conf");
           if (!buttonConf.open(QIODevice::ReadWrite | QIODevice::Text))
           return;
           QTextStream in(&buttonConf);
           in << "[theme-button]\n";
           in << "name=" + buttons->at(i)->buttonName +"\n";
           // Font weight
           QString unpressedWeight;
           QString pressedWeight;
           int uF = buttons->at(i)->unpressedFont.weight();
           int pF = buttons->at(i)->pressedFont.weight();
           switch(uF) {
               case  25:    unpressedWeight = "Light";
                            break;
               case  50:    unpressedWeight = "Normal";
                            break;
               case  75:    unpressedWeight = "Bold";
                            break;
               default:     unpressedWeight = "Normal";
                            break;
           }
           switch(pF) {
               case  25:    pressedWeight = "Light";
                            break;
               case  50:    pressedWeight = "Normal";
                            break;
               case  75:    pressedWeight = "Bold";
                            break;
               default:     pressedWeight = "Normal";
                            break;
           }
           // Font weight ends
           if(buttons->at(i)->enableFont) {
                  QString unpressedPoint;
                  unpressedPoint.setNum(buttons->at(i)->unpressedFont.pointSize() * 1024);
                  QString pressedPoint;
                  pressedPoint.setNum(buttons->at(i)->pressedFont.pointSize() * 1024);
                  in << "allow-text=true\n";
                  in << "up=unpressed.png\n";
                  in << "down=pressed.png\n";
                  in << "text-format-up=<span font_family="+ buttons->at(i)->unpressedFont.family() +" size="+
                         unpressedPoint +" weight="+ unpressedWeight +" foreground=#ffffff>%s</span>\n";
                  in << "text-format-down=<span font_family="+ buttons->at(i)->pressedFont.family() +" size="+
                         pressedPoint +" weight="+ pressedWeight +" foreground=#ffffff>%s</span>\n";
                  buttonConf.close();
              }
           else {
                  in << "allow-text=false\n";
                  in << "up=unpressed.png\n";
                  in << "down=pressed.png\n";
                  buttonConf.close();
              }
        }
        // theme.conf file
        QFile themeConf("/home/user/MyDocs/qtirreco/themes/" + theme + "/theme.conf");
        if (!themeConf.open(QIODevice::ReadWrite | QIODevice::Text))
        return;
        QTextStream in(&themeConf);
        in << "[theme]\n";
        QString themeName = m_ui->lineEdit_2->text();
        themeName = themeName.replace(QString(themeName.at(0)),QString(themeName.at(0).toUpper()),Qt::CaseInsensitive);
        for(int i=0; i<themeName.count(); i++)
            if(themeName.at(i).isSpace())
                themeName.remove(i,1);

        in << "name=" + themeName +"\n";
        in << "source=own\n";
        in << "author="+ m_ui->lineEdit->text() +"\n";
        in << "comments="+ m_ui->textEdit->toPlainText() +"\n";
        //get current date
        QDate date = QDate::currentDate();
        QString dateString = date.toString(QString("yyyy-MM-dd"));
        //get current time
        QTime time = QTime::currentTime();
        QString timeString = time.toString();
        in << "version="+dateString+" "+timeString+"\n";
        in << "preview_button=" + preview_button;
        themeConf.close();
        this->close();
        emit themeCreated();
    }
    else {
        QMessageBox::warning(this,"Theme name already exists!","Please choose a different theme name.",
                             QMessageBox::NoButton,QMessageBox::NoButton);
    }

}
