#include "qtirreco.h"
#include "ui_qtirreco.h"

QtIrreco::QtIrreco(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::QtIrrecoClass)
{


   init = false;
   showDatabaseButtons = false;
   remoteNames = new QStringList();
   lw = new LayoutWidget(this);



   QDir dir;
   if(!dir.exists("/home/user/MyDocs/qtirreco/Remotes")) {
         QString remotes("mkdir /home/user/MyDocs/qtirreco/Remotes");
         system(remotes.toAscii().data());
      }
   if(!dir.exists("/home/user/MyDocs/qtirreco/Devices")) {
        QString devices("mkdir /home/user/MyDocs/qtirreco/Devices");
        system(devices.toAscii().data());
      }
    if(!dir.exists("/home/user/MyDocs/qtirreco/themes"))
        dir.mkpath("/home/user/MyDocs/qtirreco/themes");

    remoteIndex = 0;
    //Creates empty remotes.conf file
    QFile file(DEVICECONF);
    if (!file.open(QIODevice::ReadWrite | QIODevice::Text))
        file.close();


    lw->show();
    lw->setFocus();

    buttonVector = new QVector<QPushButton*>();
    currentRemoteButtonIndex = 0;
    remoteButtonsVisible = false;

    connect(lw,SIGNAL(showOrHideMenu()),this,SLOT(showOrHideButtons()));
    connect(this,SIGNAL(remoteNameToLw(QString)),lw,SLOT(setActiveRemoteName(QString)));
    connect(lw,SIGNAL(saveFailed()),this,SLOT(showSaveError()));
    connect(this,SIGNAL(bgImageToLw(QString)),lw,SLOT(setBackgroundImagePath(QString)));
    connect(this,SIGNAL(rgbToLw(int,int,int)),lw,SLOT(setRgbInteger(int,int,int)));
    connect(this,SIGNAL(remoteDeleted()),lw,SLOT(clearScreen()));


    createButtons();
    connectButtons();

    showUseModeButtons();
    hideEditModeButtons();
    useModeEnabled = true;
    buttonsVisible = true;


   this->checkForRemotes();
   if(remoteNames->count() != 0) {
       this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
       this->setActiveRemote();
    }

    if(remoteNames->count() <= 0)
       this->noRemotes();
}

QtIrreco::~QtIrreco()
{
    // Stop lirc server
    system("sudo exec /etc/init.d/lirc stop");
    delete ui;

}
void QtIrreco::setActiveRemote()
{
     lw->setActiveRemoteName(activeRemote);
     backgroundName.clear();
     QFile file(DEVICEREMOTES + activeRemote+".conf");
        if (!file.open(QIODevice::ReadWrite | QIODevice::Text))
            return;
        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            this->readRemoteFile(line);
        }
    file.close();
}

void QtIrreco::checkForRemotes()
{
    remoteIndex = 0;
    QDir dir;

    QFile file(DEVICECONF);

    if (!file.open(QIODevice::ReadWrite | QIODevice::Text))
        return;

    remoteNames->clear();
    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        process_line(line);
    }
    init = true;
    file.close();
}

void QtIrreco::noRemotes()
{
    activeRemote.clear();
    this->setWindowTitle("Please make a new remote!");
    // Creates empty remotes.conf file

     QFile file(DEVICECONF);

     if (!file.open(QIODevice::ReadWrite | QIODevice::Text)) {}
     file.close();

     editButton->setDisabled(true);
     showButton->setDisabled(true);
     deleteButton->setDisabled(true);

     QColor defaultBgColor(50,50,50);
     palette.setColor(QPalette::Window,defaultBgColor);
     this->setPalette(palette);
     this->setAutoFillBackground(true);

     palette.setBrush(QPalette::Window, QPixmap(QString::fromUtf8(DEVICEDEFAULTIMAGE)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation));
     lw->setPalette(palette);
     lw->setAutoFillBackground(true);
}

void QtIrreco::showOrHideButtons()
{
    if(useModeEnabled) {
        if(buttonsVisible) {
            hideUseModeButtons();
            this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to show menu");
        }
        else if(!buttonsVisible) {
            showUseModeButtons();
            this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
        }
    }
    if(!useModeEnabled) {
        if(buttonsVisible) {
            hideEditModeButtons();
            this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to show menu");
        }
        else if(!buttonsVisible) {
            showEditModeButtons();
            this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
        }
    }
}

void QtIrreco::hideEditModeButtons()
{
    saveButton->hide();
    newPushButton->hide();
    renameButton->hide();
    backgroundButton->hide();
    buttonsVisible = false;
    lw->setButtonsVisible(buttonsVisible);
}

void QtIrreco::showEditModeButtons()
{
    saveButton->show();
    newPushButton->show();
    renameButton->show();
    backgroundButton->show();
    buttonsVisible = true;
}

void QtIrreco::hideUseModeButtons()
{
    themeButton->hide();
    editButton->hide();
    dataBaseButton->hide();
    newRemoteButton->hide();
    downloadButton->hide();
    deleteButton->hide();
    showButton->hide();
    aboutButton->hide();
    downDBButton->hide();
    upDBButton->hide();

    if(remoteButtonsVisible) {
        if(remoteNames->count() > 4) {
            for(int i=currentRemoteButtonIndex;i<currentRemoteButtonIndex+4;i++) {
                buttonVector->at(i)->hide();
                remoteScrollBar->deleteLater();
            }
        }
        if(remoteNames->count() <= 4) {
            for(int i=0;i<remoteNames->count();i++)
                buttonVector->at(i)->hide();

        }
    }
    buttonVector->clear();
    buttonsVisible = false;
}

void QtIrreco::showUseModeButtons()
{
    themeButton->show();
    editButton->show();
    dataBaseButton->show();
    newRemoteButton->show();
    downloadButton->show();
    deleteButton->show();
    showButton->show();
    aboutButton->show();
    dataBaseButton->show();
    // downDBButton and UpDBButton are shown when dataBaseButton is pressed
    if(showDatabaseButtons) {
        downDBButton->show();
        upDBButton->show();
    }
    else {
        downDBButton->hide();
        upDBButton->hide();
    }

    if(remoteButtonsVisible) {
        remoteButtonsVisible=false;
        this->showRemote();
    }
    buttonsVisible = true;
}

void QtIrreco::newRemote() // Using RenameRemoteDlg class
{
    RenameRemoteDlg *rrDlg = new RenameRemoteDlg(this,activeRemote);
    rrDlg->setWindowTitle("Create a new remote");
    rrDlg->setNameLabelText("Please enter remote name: ");
    rrDlg->setLabelGeometry(270,10,360,31);
    rrDlg->setPushButtonText("Create remote");
    connect(rrDlg,SIGNAL(newRemote(QString)),this,SLOT(createRemote(QString)));
    rrDlg->exec();
    delete rrDlg;
}

void QtIrreco::createRemote(QString newRemoteName)
{
    themeButton->setEnabled(true);
    editButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    showButton->setEnabled(true);
    deleteButton->setEnabled(true);
    aboutButton->setEnabled(true);
    downloadButton->setEnabled(true);
    upDBButton->setEnabled(true);
    downDBButton->setEnabled(true);
    bool alreadyExists = false;
    QString newRemoteFileName = (newRemoteName+".conf");
    for(int i=0;i<remoteNames->count();i++) {
        if(remoteNames->at(i) == newRemoteFileName) {
            QMessageBox::warning(this,"Remote name already exists!","Please choose a different remote name.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
            alreadyExists = true;
        }
    }
    if(!alreadyExists) {
        QDir dir;
        QFile newRemoteFile(DEVICEREMOTES + newRemoteName+".conf");
        if (!newRemoteFile.open(QIODevice::ReadWrite | QIODevice::Text))
            return;
        lw->clearScreen();
        lw->setBackgroundMode("default");
        lw->setBackgroundImagePath(DEVICEDEFAULTIMAGE);

        QColor defaultBgColor(50,50,50);
        palette.setColor(QPalette::Window,defaultBgColor);
        this->setPalette(palette);
        this->setAutoFillBackground(true);

        palette.setBrush(QPalette::Window, QPixmap(QString::fromUtf8(DEVICEDEFAULTIMAGE)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation));

        lw->setPalette(palette);
        lw->setAutoFillBackground(true);

        remoteNames->append(newRemoteName+".conf");

         activeRemote = newRemoteName;
         lw->setActiveRemoteName(activeRemote);
         writeRemoteChanges();
         this->hideUseModeButtons();
         this->showEditModeButtons();
         lw->setUseModeEnabled(false);
         useModeEnabled = false;
         this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
         newRemoteFile.close();
         lw->saveRemoteToFile();
        }
}

void QtIrreco::editRemote()
{
    this->showEditModeButtons();
    this->hideUseModeButtons();
    useModeEnabled = false;
    lw->setUseModeEnabled(useModeEnabled);
    buttonsVisible = true;
    this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
    lw->setFocus();

    // emits background properties to layout in case no background changes are made so saving file works.
    lw->setRgbInteger(r,g,b);
    lw->setBackgroundImagePath(backgroundName);
    lw->setBackgroundMode(backgroundMode);
}

void QtIrreco::renameRemote()
{
    RenameRemoteDlg *rrDlg = new RenameRemoteDlg(this,activeRemote);
    connect(rrDlg,SIGNAL(changeName(QString)),this,SLOT(changeNewRemoteName(QString)));
    rrDlg->setLabelGeometry(230,10,360,31);
    rrDlg->exec();
    delete rrDlg;
}

void QtIrreco::changeNewRemoteName(QString newName)
{
    bool alreadyExists = false;
    for(int i=0;i<remoteNames->count();i++) {
        if(remoteNames->at(i).contains(newName))
            alreadyExists = true;

    }
    if(alreadyExists) {
            QMessageBox::warning(this,"Remote name already exists!","Please choose different remote name.",
                         QMessageBox::NoButton,QMessageBox::NoButton);
    }
    else {
        oldRemoteName = activeRemote;
        QFile remoteFile(DEVICEREMOTES + oldRemoteName + ".conf");
        remoteFile.rename(newName+".conf");
        activeRemote = newName;
        this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
        lw->setActiveRemoteName(activeRemote);
        for(int i=0;i<remoteNames->count();i++) {
            if(remoteNames->at(i).contains(oldRemoteName))
                remoteNames->replace(i,activeRemote+".conf");

        }
        this->saveRemote();
        this->hideUseModeButtons();
        this->showEditModeButtons();
        useModeEnabled = false;
        lw->setUseModeEnabled(useModeEnabled);
        // Make changes to remotes.conf
        writeRemoteChanges();

    }
}

void QtIrreco::writeRemoteChanges() // when renaming remote or changing active remote or deleting remote
{
    QFile exConf(DEVICECONF);
    exConf.remove();
    QFile newConf(DEVICECONF);
          if (!newConf.open(QIODevice::ReadWrite | QIODevice::Text))
          return;
          QTextStream in(&newConf);
          if(remoteNames->count() > 0)
              in << activeRemote+(".conf")+ (" | current remote\n");
          for (int i=0;i<remoteNames->count();i++)
              in << remoteNames->at(i) + (" | filename of remote\n");

          newConf.close();
}

void QtIrreco::downloadRemote()
{
    DownloadRemoteDlg *dloadRmDlg = new DownloadRemoteDlg(this,true,remoteNames);
    connect(dloadRmDlg,SIGNAL(lwClearScreen()),lw,SLOT(clearScreen()));
    connect(dloadRmDlg,SIGNAL(addButtonToLayoutSignalFromRSD(QString,QString, QString, QString, QStringList,int)),this,SLOT(AddButtonToLayout(QString,QString, QString, QString, QStringList,int)));
    connect(dloadRmDlg,SIGNAL(remoteNameToLayoutWidget(QString)),lw,SLOT(setActiveRemoteName(QString)));
    connect(dloadRmDlg,SIGNAL(remoteNameToLayoutWidget(QString)),this,SLOT(addRemoteName(QString)));
    dloadRmDlg->exec();
    delete dloadRmDlg;
}

void QtIrreco::addRemoteName(QString newRemoteName)
{
    remoteNames->append(newRemoteName+".conf");
    activeRemote = newRemoteName;
    editButton->setEnabled(true);
    showButton->setEnabled(true);
    deleteButton->setEnabled(true);

   /* this->showEditModeButtons();
    this->hideUseModeButtons();
    useModeEnabled = false;
    lw->setUseModeEnabled(useModeEnabled); */



    buttonsVisible = true;
    lw->setFocus();
    lw->setBackgroundImagePath(DEVICEDEFAULTIMAGE);
    lw->setBackgroundMode("default");

    QColor defaultBgColor(50,50,50);
    palette.setColor(QPalette::Window,defaultBgColor);
    this->setPalette(palette);
    this->setAutoFillBackground(true);

    palette.setBrush(QPalette::Window, QPixmap(QString::fromUtf8(DEVICEDEFAULTIMAGE)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation));
    lw->setPalette(palette);
    lw->setAutoFillBackground(true);

    this->setActiveRemote();
    this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");

    writeRemoteChanges();
    this->saveRemote();
    this->hideUseModeButtons();
}

void QtIrreco::AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number)
{
    themeButton->setEnabled(true);
    showButton->setEnabled(true);
    deleteButton->setEnabled(true);
    aboutButton->setEnabled(true);
    editButton->setEnabled(true);
    downloadButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    upDBButton->setEnabled(true);
    downDBButton->setEnabled(true);
    lw->addButton(fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, number);
}
void QtIrreco::AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number,int timeOut)
{
    themeButton->setEnabled(true);
    showButton->setEnabled(true);
    deleteButton->setEnabled(true);
    aboutButton->setEnabled(true);
    editButton->setEnabled(true);
    downloadButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    upDBButton->setEnabled(true);
    downDBButton->setEnabled(true);
    lw->addButton(fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, QPoint(0,0), timeOut);
}


void QtIrreco::deleteRemote() // Using RenameRemoteDlg class
{
    RenameRemoteDlg *rrDlg = new RenameRemoteDlg(this,activeRemote);
    rrDlg->setGeometry(0,0,800,175);
    rrDlg->setWindowTitle("Delete remote");
    rrDlg->setNameLabelText("Are you sure you wish to delete remote: "+activeRemote+" ?");
    rrDlg->setLabelGeometry(200,25,600,50);
    rrDlg->setPushButtonText("Delete");
    rrDlg->setPushButtonGeometry(300,85,200,75);
    rrDlg->hideLineEdit();
    connect(rrDlg,SIGNAL(deleteRemote()),this,SLOT(deleteActiveRemote()));
    rrDlg->exec();
    delete rrDlg;
}

void QtIrreco::deleteActiveRemote()
{
    emit remoteDeleted();

    QFile file(DEVICEREMOTES +activeRemote+".conf");
    file.remove();
    for (int i=0;i<remoteNames->count();i++) {
        if(remoteNames->at(i).contains(activeRemote+".conf"))
            remoteNames->removeAt(i);

    }
    buttonVector->clear();
    showRemoteButtons();

    if(remoteNames->count() > 0) {
        activeRemote = remoteNames->at(0);
        activeRemote.chop(5);
        this->setActiveRemote();
        lw->setActiveRemoteName(activeRemote);
        this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
    }
    this->writeRemoteChanges();
    this->checkForRemotes();
    if(remoteNames->count() <= 0) {
       activeRemote.clear();
       QFile confFile(DEVICECONF);
       confFile.remove();
       this->noRemotes();
    }
}

void QtIrreco::about()
{
    AboutDlg *about = new AboutDlg(this);
    about->exec();
    delete about;
}

void QtIrreco::theme()
{
    ThemeManager *theme = new ThemeManager(this);
    theme->exec();
    delete theme;
}

void QtIrreco::newButton()
{
    NewButtonDlg *newButton = new NewButtonDlg(this, lw->vector);
    connect(newButton,SIGNAL(addButtonToLayoutSignal(QString,QString, QString, QString, QStringList,int,int)),this,SLOT(AddButtonToLayout(QString,QString, QString, QString, QStringList,int,int)));
    newButton->exec();
    delete newButton;
}

void QtIrreco::saveRemote()
{
    this->hideUseModeButtons();
    this->hideEditModeButtons();
    useModeEnabled = true;
    lw->setUseModeEnabled(useModeEnabled);
    buttonsVisible = false;
    this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
    lw->setFocus();
    lw->saveRemoteToFile();
    lircFileNames.clear();

    QFile file(DEVICEREMOTES + activeRemote+".conf");
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream stream(&file);
    while (!stream.atEnd()) {
        QString line = stream.readLine();

        if(line.contains("command: ",Qt::CaseInsensitive)) {
            line = line.trimmed();
            line.remove(0,9);
            QString string;

            for(int i=0;i<line.length();i++) {
                if(line.at(i).isSpace() == false)
                    string.append(line.at(i));

                if(line.at(i).isSpace() == true) {
                    if(!lircFileNames.contains(string))
                        lircFileNames.append(string);

                    i = line.length();
                }
            }
        }
    }


    file.close();
    QStringList lircFilePaths;
    QFile lircPathsFile("/home/user/MyDocs/qtirreco/lircpaths.conf");
    lircPathsFile.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&lircPathsFile);
    while (!in.atEnd()) {
        QString line = in.readLine();
        for(int i=0;i<lircFileNames.length();i++) {
            if(line.contains(lircFileNames.at(i),Qt::CaseInsensitive)) {
                for(int j=0;j<line.length();j++) {
                    if(line.at(j).isSpace())
                        line.remove(0,j+1);
                }
                if(!lircFilePaths.contains(line))
                    lircFilePaths.append(line);
            }
        }
    }
    lircPathsFile.close();

    QFile remFile(DEVICEREMOTES + activeRemote +".conf");
    remFile.open(QIODevice::WriteOnly | QIODevice::Append);


    QTextStream out(&remFile);
    out<< "\nLircConfs: ";
    for(int i= 0;i<lircFileNames.length();i++)
        out<< lircFileNames.at(i) +" ";

    out<< "\nLircPaths: " ;

    for(int i= 0;i<lircFilePaths.length();i++)
        out<< lircFilePaths.at(i) +" ";

    remFile.close();
}

void QtIrreco::downloadDB()
{
    DownloadUserRemoteDlg *downloadDlg = new DownloadUserRemoteDlg(this);
    connect(downloadDlg,SIGNAL(remoteDownloaded(QString)),this,SLOT(addDownloadedRemote(QString)));
    downloadDlg->exec();
}

void QtIrreco::uploadDB()
{
    UploadDBDlg *uploadDlg = new UploadDBDlg(this, activeRemote);
    uploadDlg->exec();
    delete uploadDlg;
    downDBButton->hide();
    upDBButton->hide();
    themeButton->setEnabled(true);
    editButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    newRemoteButton->setEnabled(true);
    downloadButton->setEnabled(true);
    deleteButton->setEnabled(true);
    showButton->setEnabled(true);
    aboutButton->setEnabled(true);
    showDatabaseButtons = false;
}
void QtIrreco::showDBButtons()
{
    if(showDatabaseButtons) {
        downDBButton->hide();
        upDBButton->hide();
        showDatabaseButtons = false;
    }
    else {
        downDBButton->show();
        upDBButton->show();
        showDatabaseButtons = true;
    }

    if(aboutButton->isEnabled()) {
        themeButton->setDisabled(true);
        editButton->setDisabled(true);
        newRemoteButton->setDisabled(true);
        downloadButton->setDisabled(true);
        deleteButton->setDisabled(true);
        showButton->setDisabled(true);
        aboutButton->setDisabled(true);
        downDBButton->setEnabled(true);

        if(remoteNames->isEmpty())
            upDBButton->setDisabled(true);

        else upDBButton->setEnabled(true);

    }
    else {
        themeButton->setEnabled(true);
        dataBaseButton->setEnabled(true);
        newRemoteButton->setEnabled(true);
        downloadButton->setEnabled(true);
        aboutButton->setEnabled(true);
        downDBButton->setDisabled(true);
        upDBButton->setDisabled(true);

        if(remoteNames->isEmpty()) {
            editButton->setDisabled(true);
            showButton->setDisabled(true);
            deleteButton->setDisabled(true);
        }
        else {
            editButton->setEnabled(true);
            showButton->setEnabled(true);
            deleteButton->setEnabled(true);
        }
    }
}

void QtIrreco::showRemote()
{
    if(remoteNames->count() > 0) {
        if(remoteButtonsVisible) { // Hides remotes
            if(remoteNames->count() > 4) {
                for(int i=currentRemoteButtonIndex;i<currentRemoteButtonIndex+4;i++) {
                    buttonVector->at(i)->hide();
                    remoteScrollBar->deleteLater();
                }
            }
            if(remoteNames->count() <= 4) {
                for(int i=0;i<remoteNames->count();i++)
                    buttonVector->at(i)->hide();

            }
            buttonVector->clear();
            showButton->setText("Show Remotes");
            themeButton->setEnabled(true);
            deleteButton->setEnabled(true);
            newRemoteButton->setEnabled(true);
            aboutButton->setEnabled(true);
            editButton->setEnabled(true);
            dataBaseButton->setEnabled(true);
            downloadButton->setEnabled(true);
            upDBButton->setEnabled(true);
            downDBButton->setEnabled(true);

            remoteButtonsVisible = false;
        }
        else {
            remoteIndex = 0;
            activeRemote.clear();
            remoteNames->clear();

            QFile file(DEVICECONF);
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
            return;
            QTextStream in(&file);
            while (!in.atEnd()) {
                QString line = in.readLine();
                process_line(line);
            }
            if(!remoteButtonsVisible && init)
                showRemoteButtons();
        }
    }
}

void QtIrreco::readRemoteFile(QString line)
{
    if(line.contains("Background: ",Qt::CaseInsensitive)) {
        backgroundMode.clear();
        line = line.trimmed();
        line.remove(0,12);
        backgroundMode = line;
        lw->setBackgroundMode(backgroundMode);
    }
    if(line.contains("Image: ",Qt::CaseInsensitive)) {
        line = line.trimmed();
        backgroundName = line.remove(0,7);
    }
    if(line.contains("Color:",Qt::CaseInsensitive)) {
        QString str[3];

        line = line.trimmed();
        line.remove(0,7);
        int lineLength = line.length();
        int index = 0;
        for(int i=0;i<lineLength;i++) {
            if(line.at(i).isSpace() == false)
                str[index].append(line.at(i));

            if(line.at(i).isSpace() == true && index <=2)
                index++;

        }
        red = str[0];
        green = str[1];
        blue = str[2];
    }
     // Button reading
    if(line.contains("Button:",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,8);
        buttonText = line;
    }
    if(line.contains("fileNameUnPressed:",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,19);
        fileNameUnPressed = line;
    }
    if(line.contains("fileNamePressed:",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,17);
        fileNamePressed = line;
    }
    if(line.contains("confFileName:",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,14);
        confFileName = line;
    }
    if(line.contains("position:",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,10);
        int index;
        int lineLength;
        lineLength = line.length();
        index = line.indexOf(",");
        xPosition = line.left(index);
        yPosition = line.right(lineLength - (index+1));
    }
     if(line.contains("timeout: ",Qt::CaseInsensitive)) {
        timeOut = 1000;
        line = line.trimmed();
        line.remove(0,9);
        bool ok;
        timeOut = line.toInt(&ok);
    }
    if(line.contains("command: ",Qt::CaseInsensitive)) {
        line = line.trimmed();
        line.remove(0,9);
        commandChain.append(line);

    }
    if(line.contains("end commandChain",Qt::CaseInsensitive)) {
        int x,y;
        bool ok;
        x = xPosition.toInt(&ok,10);
        y = yPosition.toInt(&ok,10);
        position.setX(x);
        position.setY(y);
        lw->addButton(fileNameUnPressed,fileNamePressed,confFileName,buttonText,commandChain,position,timeOut);
        commandChain.clear();
    }

    // button reading ends
    bool ok;
    r = red.toInt(&ok,10);
    g = green.toInt(&ok,10);
    b = blue.toInt(&ok,10);

    emit rgbToLw(r,g,b);
    QColor rgb(r,g,b);
    this->changeBackground(backgroundName,rgb);
}

void QtIrreco::process_line(QString line)
{
    line = line.trimmed();

    if(line.contains("current remote",Qt::CaseInsensitive)) {
          line.chop(17);
          activeRemote = line;
          activeRemote.chop(5);
    }
    if(line.contains("filename of remote",Qt::CaseInsensitive)) {
        line.chop(21);
        remoteNames->append(line);
    }
}

void QtIrreco::changeRemote()
{
   for(int i=0;i<remoteNames->count();i++) {
       if(buttonVector->at(i)->underMouse()) {
            lw->clearScreen();
            activeRemote.clear();
            activeRemote = buttonVector->at(i)->text();
            this->setActiveRemote();
            this->writeRemoteChanges();
        }
    }
     // hide remotes
    if(remoteNames->count() > 4) {
        for(int i=currentRemoteButtonIndex;i<currentRemoteButtonIndex+4;i++) {
            buttonVector->at(i)->hide();
            remoteScrollBar->deleteLater();
        }
    }
    if(remoteNames->count() <= 4) {
        for(int i=0;i<remoteNames->count();i++)
            buttonVector->at(i)->hide();

    }
    remoteButtonsVisible = false;
    showButton->setText("Show Remotes");
    themeButton->setEnabled(true);
    deleteButton->setEnabled(true);
    newRemoteButton->setEnabled(true);
    aboutButton->setEnabled(true);
    editButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    downloadButton->setEnabled(true);
    upDBButton->setEnabled(true);
    downDBButton->setEnabled(true);

    this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
}

void QtIrreco::showRemoteButtons()
{
    int y=0;
    remoteIndex = 0;
    buttonVector->clear();
    for(int i=0;i<remoteNames->count();i++) {
        QString rn[remoteNames->count()];
        rn[i] = remoteNames->at(i);
        rn[i].chop(5);
      //  remoteNames->at(i).chop(5);

        remoteButton = new QPushButton(this);
        buttonVector->append(remoteButton);
        buttonVector->at(i)->setText(rn[i]);

        connect(buttonVector->at(i), SIGNAL(clicked()), this, SLOT(changeRemote()));
    }
    if(remoteNames->count() <=4) {
        for(int i=0;i<remoteNames->count();i++) {
            buttonVector->at(i)->setGeometry(QRect(540,40+y,150,75));
            y+=75;
            buttonVector->at(i)->show();
            remoteButtonsVisible = true;
            showButton->setText("Hide Remotes");
            deleteButton->setDisabled(true);
            newRemoteButton->setDisabled(true);
            aboutButton->setDisabled(true);
            themeButton->setDisabled(true);
            editButton->setDisabled(true);
            dataBaseButton->setDisabled(true);
            downloadButton->setDisabled(true);
            upDBButton->setDisabled(true);
            downDBButton->setDisabled(true);
        }
    }
    else {
        for(int i=0;i<4;i++) {
            buttonVector->at(i)->setGeometry(QRect(540,40+y,150,75));
            y+=75;
            buttonVector->at(i)->show();
            remoteButtonsVisible = true;
            showButton->setText("Hide Remotes");
            deleteButton->setDisabled(true);
            newRemoteButton->setDisabled(true);
            aboutButton->setDisabled(true);
            themeButton->setDisabled(true);
            editButton->setDisabled(true);
            dataBaseButton->setDisabled(true);
            downloadButton->setDisabled(true);
            upDBButton->setDisabled(true);
            downDBButton->setDisabled(true);
        }
    }
    if(remoteNames->count() > 4) {
        remoteScrollBar = new QScrollBar(this);
        currentRemoteButtonIndex = 0;
        remoteScrollBar->setGeometry(QRect(715,40,60,300));
        connect(remoteScrollBar,SIGNAL(valueChanged(int)),this,SLOT(scrollRemoteButtons(int)));
        remoteScrollBar->setMaximum(buttonVector->count()-4);
        remoteScrollBar->show();
        remoteScrollBar->setValue(0);
    }
}

void QtIrreco::scrollRemoteButtons(int index)
{
    int y=0;
    for(int i=0;i<4;i++)
        buttonVector->at(currentRemoteButtonIndex + i)->hide();

    for(int i=index;i<index+4;i++) {
        buttonVector->at(i)->setGeometry(QRect(540,40+y,150,75));
        y+=75;
        buttonVector->at(i)->show();
    }
    currentRemoteButtonIndex = index;
}

void QtIrreco::background()
{
    bg = new BackgroundDlg(this);
    connect(bg,SIGNAL(backgroundChanged(QString)),lw,SLOT(setBackgroundMode(QString)));
    connect(bg,SIGNAL(backgroundChanged(QString)),this,SLOT(changeBackground()));
    connect(bg,SIGNAL(rgbToLw(QString,QString,QString)),lw,SLOT(setRgbValues(QString,QString,QString)));
    bg->exec();
}

void QtIrreco::changeBackground()
{
    lw->setBackgroundImagePath(bg->returnBackgroundImagePath());

    if(bg->isDefaultImageSelected()) {
        QColor defaultBgColor(50,50,50);
        palette.setColor(QPalette::Window,defaultBgColor);
        this->setPalette(palette);
        this->setAutoFillBackground(true);

        palette.setBrush(QPalette::Window, QPixmap(QString::fromUtf8(DEVICEDEFAULTIMAGE)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation));
        lw->setPalette(palette);
        lw->setAutoFillBackground(true);
    }
    else {
        QPixmap backImage = bg->returnBackgroundPixmap();
        QPixmap backColor = bg->returnBackgroundPixmapColor();

        palette.setBrush(QPalette::Window,backColor);
        this->setPalette(palette);
        this->setAutoFillBackground(true);

        palette.setBrush(QPalette::Window, backImage);
        lw->setPalette(palette);
        lw->setAutoFillBackground(true);
    }
}

void QtIrreco::changeBackground(QString backgroundName, QColor backgroundColor)
{
    lw->setBackgroundImagePath(backgroundName);

    if( backgroundName == "default") {
        QColor defaultBgColor(50,50,50);
        palette.setColor(QPalette::Window,defaultBgColor);
        this->setPalette(palette);
        this->setAutoFillBackground(true);

        palette.setBrush(QPalette::Window, QPixmap(QString::fromUtf8(DEVICEDEFAULTIMAGE)).scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation));
        lw->setPalette(palette);
        lw->setAutoFillBackground(true);
    }
    else {
        palette.setColor(QPalette::Window,backgroundColor);
        this->setPalette(palette);
        this->setAutoFillBackground(true);

        QPixmap backImage(backgroundName);
        backImage = backImage.scaled(800,424,Qt::IgnoreAspectRatio,Qt::FastTransformation);

        palette.setBrush(QPalette::Window, backImage);
        lw->setPalette(palette);
        lw->setAutoFillBackground(true);
    }
}

void QtIrreco::createButtons()
{
    editButton = new QPushButton(this);
    editButton->setObjectName(QString::fromUtf8("editButton"));
    editButton->setText("Edit Remote");
    editButton->setGeometry(QRect(120, 10, 200, 100));
    newRemoteButton = new QPushButton(this);
    newRemoteButton->setObjectName(QString::fromUtf8("newRemoteButton"));
    newRemoteButton->setText("New Remote");
    newRemoteButton->setGeometry(QRect(320, 10, 200, 100));
    showButton = new QPushButton(this);
    showButton->setObjectName(QString::fromUtf8("showButton"));
    showButton->setText("Show Remotes");
    showButton->setGeometry(QRect(320, 110, 200, 100));
    downloadButton = new QPushButton(this);
    downloadButton->setObjectName(QString::fromUtf8("downloadButton"));
    downloadButton->setText("Download Remote");
    downloadButton->setGeometry(QRect(120, 110, 200, 100));
    aboutButton = new QPushButton(this);
    aboutButton->setObjectName(QString::fromUtf8("aboutButton"));
    aboutButton->setText("About");
    aboutButton->setGeometry(QRect(120, 310, 200, 100));
    deleteButton = new QPushButton(this);
    deleteButton->setObjectName(QString::fromUtf8("deleteButton"));
    deleteButton->setText("Delete Remote");
    deleteButton->setGeometry(QRect(320, 210, 200, 100));
    themeButton = new QPushButton(this);
    themeButton->setObjectName(QString::fromUtf8("themeButton"));
    themeButton->setText("Theme manager");
    themeButton->setGeometry(QRect(120, 210, 200, 100));
    dataBaseButton = new QPushButton(this);
    dataBaseButton->setObjectName(QString::fromUtf8("dataBaseButton"));
    dataBaseButton->setText("Remote Database");
    dataBaseButton->setGeometry(QRect(320, 310, 200, 100));
    downDBButton = new QPushButton(this);
    downDBButton->setObjectName(QString::fromUtf8("downDBButton"));
    downDBButton->setText("Download from DB");
    downDBButton->setGeometry(QRect(540, 210, 200, 100));
    upDBButton = new QPushButton(this);
    upDBButton->setObjectName(QString::fromUtf8("upDBButton"));
    upDBButton->setText("Upload to DB");
    upDBButton->setGeometry(QRect(540, 310, 200, 100));
    saveButton = new QPushButton(this);
    saveButton->setObjectName(QString::fromUtf8("saveButton"));
    saveButton->setText("Save Remote");
    saveButton->setGeometry(QRect(120, 40, 400, 100));
    newPushButton = new QPushButton(this);
    newPushButton->setObjectName(QString::fromUtf8("newButton"));
    newPushButton->setText("New Button");
    newPushButton->setGeometry(QRect(120, 140, 400, 100));
    renameButton = new QPushButton(this);
    renameButton->setObjectName(QString::fromUtf8("renameButton"));
    renameButton->setText("Rename Remote");
    renameButton->setGeometry(QRect(120, 240, 200, 100));
    backgroundButton = new QPushButton(this);
    backgroundButton->setObjectName(QString::fromUtf8("backgroundButton"));
    backgroundButton->setText("Background");
    backgroundButton->setGeometry(QRect(320, 240, 200, 100));
}

void QtIrreco::connectButtons()
{
    connect(editButton,SIGNAL(clicked()),this,SLOT(editRemote()));
    connect(newRemoteButton, SIGNAL(clicked()),this,SLOT(newRemote()));
    connect(showButton,SIGNAL(clicked()),this,SLOT(showRemote()));
    connect(downloadButton,SIGNAL(clicked()),this,SLOT(downloadRemote()));
    connect(aboutButton,SIGNAL(clicked()),this,SLOT(about()));
    connect(deleteButton,SIGNAL(clicked()),this,SLOT(deleteRemote()));
    connect(downDBButton,SIGNAL(clicked()),this,SLOT(downloadDB()));
    connect(upDBButton,SIGNAL(clicked()),this,SLOT(uploadDB()));
    connect(dataBaseButton,SIGNAL(clicked()),this,SLOT(showDBButtons()));
    connect(renameButton,SIGNAL(clicked()),this,SLOT(renameRemote()));
    connect(themeButton,SIGNAL(clicked()),this,SLOT(theme()));
    connect(newPushButton,SIGNAL(clicked()),this,SLOT(newButton()));
    connect(saveButton,SIGNAL(clicked()),this,SLOT(saveRemote()));
    connect(backgroundButton,SIGNAL(clicked()),this,SLOT(background()));
}

void QtIrreco::showSaveError()
{
    QMessageBox::warning(this,"Error occured with saving","Please try saving remote again.Current mode: "+backgroundMode+
                         "\nCurrent background: "+backgroundName+"!",
                     QMessageBox::NoButton,QMessageBox::NoButton);
}

void QtIrreco::addDownloadedRemote(QString remName)
{
    downDBButton->hide();
    upDBButton->hide();
    themeButton->setEnabled(true);
    editButton->setEnabled(true);
    dataBaseButton->setEnabled(true);
    newRemoteButton->setEnabled(true);
    downloadButton->setEnabled(true);
    deleteButton->setEnabled(true);
    showButton->setEnabled(true);
    aboutButton->setEnabled(true);
    showDatabaseButtons = false;
    lastTheme = false;
    QString remConf = remName;
    remConf.chop(5);
    remoteNames->append(remName);
    activeRemote = remConf;
    //Download Lirc configurations if needed
    checkLircFilesForRemote(remName);
    //Download themes if needed
    checkThemesForRemote(remName);
}

void QtIrreco::checkThemesForRemote(QString remoteFile)
{
    QString themeTemp;
    QFile file(DEVICEREMOTES + remoteFile);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
        QTextStream in(&file);
        while (!in.atEnd()) {
            QString line = in.readLine();
            if(line.contains("Themes: ",Qt::CaseInsensitive)) {
                line.remove(0,8);
                for(int i=0;i<line.length();i++) {
                    if(!line.at(i).isSpace())
                        themeTemp.append(line.at(i));

                    else {
                        themesForRemote.append(themeTemp);
                        themeTemp.clear();
                    }
                }

            }
            if(line.contains("Theme versions: ",Qt::CaseInsensitive)) {
                line.remove(0,16);
                for(int i=0;i<line.length();i++) {
                    if(line.at(i) != '/')
                        themeTemp.append(line.at(i));

                    else {
                        themeVersionsForRemote.append(themeTemp);
                        themeTemp.clear();
                    }
                }

            }
        }
    file.close();

    QDir dir("/home/user/MyDocs/qtirreco/themes/");
    for(int i=0;i<themesForRemote.length();i++) {
        if(dir.exists(themesForRemote.at(i))) {
            themesForRemote.removeAt(i);
            themeVersionsForRemote.removeAt(i);
            i--;
        }
    }

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));

    if(themesForRemote.isEmpty()) {
        lw->setActiveRemoteName(activeRemote);
        this->writeRemoteChanges();
        this->checkForRemotes();
        this->setActiveRemote();
        this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
        editButton->setEnabled(true);
        showButton->setEnabled(true);
        deleteButton->setEnabled(true);
    }
    themeDownloadCount = 0;
    progress = new QProgressBar(this);
    progress->setGeometry(650,10,128,64);
    progress->setRange(0,100);
    connect(this,SIGNAL(progressState(int)),progress,SLOT(setValue(int)));
    connect(this,SIGNAL(themeLoaded()),progress,SLOT(deleteLater()));
    progress->show();
    this->downloadTheme();
}
void QtIrreco::downloadTheme()
{
    if( themeDownloadCount < themesForRemote.count() ) {
        themeButtonIndex = 0;
        themeBgIndex = 0;
        progressValue = 0;

        QString upperCaseName = themesForRemote.at(themeDownloadCount);
        upperCaseName.replace(QString(upperCaseName.at(0)),QString(upperCaseName.at(0).toUpper()),Qt::CaseSensitive);
        QMessageBox::information(this,"Downloading theme","Downloading " + upperCaseName + " theme version " + themeVersionsForRemote.at(themeDownloadCount),
                                 QMessageBox::NoButton,QMessageBox::NoButton);
        themeNameFromConf = upperCaseName;
        themeVersion = themeVersionsForRemote.at(themeDownloadCount);
        QList<QVariant> params;
        params.append(themeNameFromConf);
        params.append(themeVersion);

        themeIdFromNameAndVersion = client->call("getThemeIdByNameAndDate",params);
    }
    else {
       if(!themesForRemote.isEmpty())
            QMessageBox::information(this,"Theme manager","Themes downloaded succesfully.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
        this->setEnabled(true);
        lw->clearScreen();
        lw->setActiveRemoteName(activeRemote);
        this->writeRemoteChanges();
        this->checkForRemotes();
        this->setActiveRemote();
        this->setWindowTitle("QtIrreco:"+activeRemote+" - Click to hide menu");
        editButton->setEnabled(true);
        showButton->setEnabled(true);
        deleteButton->setEnabled(true);
        themesForRemote.clear();
        progressValue = 0;
        emit themeLoaded();
    }
}
void QtIrreco::checkLircFilesForRemote(QString remoteFile)
{
    QString temp;
    lircPathsForRemote.clear();
    lircConfs.clear();
    QFile file(DEVICEREMOTES + remoteFile);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        if(line.contains("LircPaths: ",Qt::CaseInsensitive)) {
            line.remove(0,11);
            for(int i=0;i<line.length();i++) {
                if(!line.at(i).isSpace()) {
                    temp.append(line.at(i));
                }
                else {
                    lircPathsForRemote.append(temp);
                    temp.clear();
                }
            }
        }
        if(line.contains("LircConfs: ",Qt::CaseInsensitive)) {
            line.remove(0,11);
            for(int i=0;i<line.length();i++) {
                if(!line.at(i).isSpace())
                    temp.append(line.at(i));

                else {
                    lircConfs.append(temp);
                    temp.clear();
                }
            }

        }
    }
    file.close();
    QDir dir(DEVICES);
    for(int i=lircConfs.length()-1;i>-1;i--) {
        if(dir.exists(lircConfs.at(i))) {
            lircConfs.removeAt(i);
            lircPathsForRemote.removeAt(i);
        }
    }

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));

    QList<QVariant> params;
    for(callCounter=0;callCounter<lircConfs.length();callCounter++) {
        QMessageBox::information(this,"Lirc configuration","Configuration " + lircConfs.at(callCounter) + " downloaded succesfully!",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
        params.append(lircPathsForRemote.at(callCounter));
        fileId = client->call("getLircFile",params);
        params.clear();
    }
}
void QtIrreco::processReturnValue(int Id,QVariant data)
{
    QStringList sList;
    sList = data.toStringList();
    if(Id == themeIdFromNameAndVersion) {
        downloadId = data.toInt();
        QList<QVariant> params;
        params.clear();
        params.append(data.toInt());
        themeDatas = client->call("getThemeById",params);

    }
    if (Id == themeDatas) {
        QMap<QString,QVariant> array = data.toMap();
        QVariant name = array.value("name");
        themeNameFromConf = name.toString();
        QVariant user = array.value("user");
        themeAuthor = user.toString();
        QVariant comment = array.value("comment");
        themeComments = comment.toString();
        QVariant folder = array.value("folder");
        themeFolder = folder.toString();

        QVariant preview_button = array.value("preview_button");
        themePreviewButton = preview_button.toString();

        this->setWindowTitle("Loading theme buttons...");
        this->setDisabled(true);
        dbButtonIdsList.clear();
        QList<QVariant> params;
        params.clear();
        params.append(downloadId);
        themeButtonIds = client->call("getButtons",params);
    }
    if (Id == themeButtonIds) {
        dbButtonIdsList = sList;
        this->getThemeButtonsByIds();

    }
    if (Id == buttonData) { // COPY BUTTONS AND MAKE FOLDERS

        progressValue += 100 / (dbButtonIdsList.count()+2);
        emit progressState(progressValue);
        themeButtonIndex++;
        QMap<QString,QVariant> array = data.toMap();
        QVariant name = array.value("name");
        QVariant allow_text = array.value("allow_text");
        QVariant text_format_up = array.value("text_format_up");
        QVariant text_format_down = array.value("text_format_down");
        QVariant text_padding = array.value("text_padding");
        QVariant h_align = array.value("h_align");
        QVariant v_align = array.value("v_align");
        QVariant image_up_hash = array.value("image_up_hash");
        unpressedHash = image_up_hash.toString();
        QVariant image_up_name = array.value("image_up_name");
        QVariant image_down_hash = array.value("image_down_hash");
        pressedHash = image_down_hash.toString();
        QVariant image_down_name = array.value("image_down_name");
        QVariant folder = array.value("folder");

        QDir dir;
        dir.mkpath("/home/user/MyDocs/qtirreco/themes/"+themeFolder+"/buttons/"+folder.toString().toLower());
        buttonPath = QString("/home/user/MyDocs/qtirreco/themes/"+themeFolder+"/buttons/"+folder.toString().toLower());
        if(themeButtonIndex == 1) {
            QFile themeConf("/home/user/MyDocs/qtirreco/themes/"+themeFolder+"/theme.conf");
            if (!themeConf.open(QIODevice::ReadWrite | QIODevice::Text))
            return;
            QTextStream in(&themeConf);
            in << "[theme]\n";
            in << "name="+ themeNameFromConf +"\n";
            in << "source=database\n";
            in << "author="+ themeAuthor +"\n";
            in << "comments="+ themeComments +"\n";
            in << "version="+ themeVersion +"\n";
            in << "preview_button=" + themePreviewButton;
            themeConf.close();
        }



        QFile buttonConf(buttonPath+"/button.conf");
        if (!buttonConf.open(QIODevice::ReadWrite | QIODevice::Text))
        return;
        QTextStream in2(&buttonConf);
        in2 << "[theme-button]\n";
        in2 << "name="+name.toString()+"\n";
        in2 << "allow-text="+allow_text.toString()+"\n";
        in2 << "up=unpressed.png\n";
        in2 << "down=pressed.png\n";
        if(allow_text.toBool() == true) {
            in2 << "text-format-up="+text_format_up.toString()+"\n";
            in2 << "text-format-down="+text_format_down.toString()+"\n";
        }

        buttonConf.close();
        // Get button imagedatas and make .png files
        this->getUnpressedImage();
    }
    if (Id == unpressedToFile)  { // Name always unpressed.png
        QPixmap previewPix(128,128);
        QByteArray pb = data.toByteArray();
        QByteArray ba = QByteArray::fromBase64(pb);
        previewPix.loadFromData(ba);
        previewPix.save(buttonPath+"/unpressed.png","PNG");
        this->getPressedImage();
    }
    if (Id == pressedToFile) { // Name always pressed.png
        QPixmap previewPix(128,128);
        QByteArray pb = data.toByteArray();
        QByteArray ba = QByteArray::fromBase64(pb);
        previewPix.loadFromData(ba);
        previewPix.save(buttonPath+"/pressed.png","PNG");
        this->getThemeButtonsByIds();
    }
    if (Id == themeBgIds) {
        dbBackgroundIdsList = sList;
        if(dbBackgroundIdsList.count() > 0 && !dbBackgroundIdsList.contains("0")) {
            this->setWindowTitle("Downloading theme backgrounds...");
            this->getThemeBackgroundsByIds();
        }
        else {
            themeDownloadCount++;
            this->downloadTheme();
        }
    }
    if (Id == bgData) {
        themeBgIndex++;
        progressValue += 100 / (dbButtonIdsList.count()+2);
        emit progressState(progressValue);
        QMap<QString,QVariant> array = data.toMap();
        QVariant name = array.value("name");
        QVariant image_hash = array.value("image_hash");
        bgHash = image_hash.toString();
        QVariant image_name = array.value("image_name");
        QVariant folder = array.value("folder");

        QDir dir;
        dir.mkpath("/home/user/MyDocs/qtirreco/themes/"+themeFolder+"/bg/"+folder.toString());
        bgPath = QString("/home/user/MyDocs/qtirreco/themes/"+themeFolder+"/bg/"+folder.toString());
        QFile bgConf(bgPath+"/bg.conf");
        if (!bgConf.open(QIODevice::ReadWrite | QIODevice::Text))
        return;
        QTextStream in(&bgConf);
        in << "[theme-bg]\n";
        in << "name="+name.toString()+"\n";
        in << "image=image.png";
        bgConf.close();
        // Get background imagedatas and make .png files
        this->getBgImage();
    }
    if (Id == bgToFile) {
        QPixmap previewPix(128,128);
        QByteArray pb = data.toByteArray();
        QByteArray ba = QByteArray::fromBase64(pb);
        previewPix.loadFromData(ba);
        previewPix.save(bgPath+"/image.png","PNG");
        this->getThemeBackgroundsByIds();
    }
    if (Id == fileId) {
        if(!QFile::exists(DEVICES + lircConfs.at(callCounter-1))) {
            QFile deviceFile(DEVICES +lircConfs.at(callCounter-1));
            deviceFile.open(QIODevice::WriteOnly | QIODevice::Text);
            QTextStream out(&deviceFile);
            for(int i= 0; i< sList.count();i++)
                out << sList.at(i);

            deviceFile.close();

            QFile LircConfFile("/etc/lircd.conf");
            QStringList deviceList;
            LircConfFile.open(QIODevice::ReadWrite | QIODevice::Text);
            QTextStream io(&LircConfFile);
            while (!io.atEnd()) {
                QString line = io.readLine();
                deviceList.append(line);
            }
            LircConfFile.resize(0);
            QString lastLine;

            for(int j = 0; j<sList.count();j++) {
                lastLine =  sList.at(j);

                if (lastLine.contains("end", Qt::CaseInsensitive)) {
                    if(!deviceList.contains(lircConfs.at(callCounter-1),Qt::CaseInsensitive))
                       deviceList.append("include \"/home/user/MyDocs/qtirreco/Devices/" + lircConfs.at(callCounter-1) + "\"");

                    for(int i= 0; i< deviceList.count();i++)
                        io << deviceList.at(i)+"\n";

                    j=sList.count();
                }
            }
            LircConfFile.close();

            QFile lircPathsFile("/home/user/MyDocs/qtirreco/lircpaths.conf");
            lircPathsFile.open(QIODevice::WriteOnly | QIODevice::Append);
            QTextStream stream(&lircPathsFile);
            stream << lircConfs.at(callCounter-1) + " "+ lircPathsForRemote.at(callCounter-1) + "\n";
            lircPathsFile.close();

        }
    }
}

void QtIrreco::error(int i ,QString string)
{
    QMessageBox::warning(this,"Error",string,
                                 QMessageBox::NoButton,QMessageBox::NoButton);
}

void QtIrreco::fault(int i,int j,QString string)
{
    QMessageBox::warning(this,"Fault",string,
                                 QMessageBox::NoButton,QMessageBox::NoButton);
}
void QtIrreco::getUnpressedImage()
{
    QList<QVariant> params;
    params.clear();
    params.append(unpressedHash);
    QString unpressedName = "unpressed.png";
    params.append(unpressedName);
    unpressedToFile = client->call("getImageData",params);
}
void QtIrreco::getPressedImage()
{
    QList<QVariant> params;
    params.clear();
    params.append(pressedHash);
    QString pressedName = "pressed.png";
    params.append(pressedName);
    pressedToFile = client->call("getImageData",params);
}
void QtIrreco::getBgImage()
{
    QList<QVariant> params;
    params.clear();
    params.append(bgHash);
    QString pressedName = "image.png";
    params.append(pressedName);
    bgToFile = client->call("getImageData",params);
}
void QtIrreco::getThemeButtonsByIds()
{
     if(themeButtonIndex < dbButtonIdsList.count()) {
            QList<QVariant> params;
            params.clear();
            QString idString = dbButtonIdsList.at(themeButtonIndex);
            bool ok;
            int idInt = idString.toInt(&ok,10);
            params.append(idInt);
            buttonData = client->call("getButtonById",params);
        }
    else {
        dbBackgroundIdsList.clear();
        QList<QVariant> params;
        params.clear();
        params.append(downloadId);
        themeBgIds = client->call("getBackgrounds",params);
    }
}
void QtIrreco::getThemeBackgroundsByIds()
{
    if(themeBgIndex < dbBackgroundIdsList.count()) {
         QList<QVariant> params;
         params.clear();
         QString idString = dbBackgroundIdsList.at(themeBgIndex);
         bool ok;
         int idInt = idString.toInt(&ok,10);
         params.append(idInt);
         bgData = client->call("getBgById",params);
    }
    if(themeBgIndex == dbBackgroundIdsList.count()) {
        themeDownloadCount++;
        this->downloadTheme();
    }
}
