#include "logindbdlg.h"
#include "ui_logindbdlg.h"
#include "registerdlg.h"
LoginDbDlg::LoginDbDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::LoginDbDlg)
{
    m_ui->setupUi(this);
    this->setWindowTitle("Login to database");

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));
}

LoginDbDlg::~LoginDbDlg()
{
    delete m_ui;
}

void LoginDbDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void LoginDbDlg::on_registerPushButton_clicked()
{
    RegisterDlg *regDlg = new RegisterDlg(this);
    regDlg->exec();
    delete regDlg;
}

void LoginDbDlg::processReturnValue(int Id,QVariant data)
{
    if (Id == loginId) {
        emit loginReady(m_ui->usernameLineEdit->text(),*hashpwd);
        this->close();
    }
}

void LoginDbDlg::error(int i ,QString string)
{
    QMessageBox::warning(this,"Error. ",""+ string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}

void LoginDbDlg::fault(int i,int j,QString string)
{
    QMessageBox::warning(this,"Fault. ",""+ string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}

void LoginDbDlg::on_okPushButton_2_clicked()
{
    QByteArray hasharray(QCryptographicHash::hash(m_ui->passwordLineEdit->text().toUtf8(),QCryptographicHash::Sha1));
    hasharray = hasharray.toHex();
    hashpwd = new QString(hasharray);

    QList<QVariant> params;
    params.append(m_ui->usernameLineEdit->text());
    params.append(*hashpwd);
    loginId = client->call("loginToDB",params);
}
