/* --------------------------------------------------------------------------------------------
Copyright 2009 Robin Nilsson <robinnilsson@gmail.com>. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Robin Nilsson ``AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Robin Nilsson OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the
authors and should not be interpreted as representing official policies, either expressed
or implied, of Robin Nilsson.
------------------------------------------------------------------------------------------- */

#ifndef DESPOTIFYWRAP_H
#define DESPOTIFYWRAP_H

#include <list>
#include <QObject>

#include "despotify_cpp.h"
#include "audio.h"
#include "despotifyplay.h"
#include "despotifycallback.h"

class DespotifyWrap : public QObject {
    Q_OBJECT

private:
    ao_device* audio_device;
    despotify_session* ds;
    bool initialized;
    playlist* playlists;
    playlist* searchlist;

    track* current_track;
    int current_offset;

public:
    track* lastlist;
    track* pending_playlist;
    track* pending_search;
    track* pending_album;

    album_browse* album;

    DespotifyPlay *player;

    DespotifyWrap();
    ~DespotifyWrap();

    bool Authenticate(char *user, char *pass);
    bool UpdatePlaylists();
    bool IsInitialized();
    void Play(int list_offset);
    void PlayNext();
    void PlayPrev();
    bool Search(char *search);
    void Exit();
    const char* GetError();
    playlist* GetPlaylists();
    void GetAlbumFromID(unsigned char* id);
    const uchar* GetImage(char* id,int* img_len);

signals:
    void PlaylistsUpdated();

};



#endif // DESPOTIFYWRAP_H
