#include <QDebug>
#include "despotifycallback.h"

DespotifyCallback dc;

void DespotifyCallback::ReceiveCallback(int signal, void* data, void* callback_data) {
    switch (signal) {
        case DESPOTIFY_NEW_TRACK: {

            track* t = (track*)data;

            int min = (int)t->length / 60000;
            int sec = (int)t->length % 60000 / 1000;

            emit this->NewTrack(min,sec,(int)(t->length/1000),t);

            break;
        }

        case DESPOTIFY_TIME_TELL: {

            int seconds = -1;
            int sec = 0;
            int min = 0;

            if ((int)(*((double*)data)) != seconds) {
                seconds = *((double*)data);
                min = seconds / 60;
                sec = seconds % 60;
            }

            emit this->TellTime(min,sec,seconds);

            break;
        }

        case DESPOTIFY_END_OF_PLAYLIST:{
            emit this->EndOfPlaylist();
            // thread_pause();
        }
    }

}
