#include <QDebug>
#include <list>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "despotifycallback.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    /* Initialize despotify */
    this->dw = new DespotifyWrap();
    qDebug() << "Is spotify initialized? " << this->dw->IsInitialized();

    /* Connect signals */
    this->connect(this->dw, SIGNAL(PlaylistsUpdated()),this, SLOT(PlaylistsUpdated()));
    this->connect(&dc, SIGNAL(NewTrack(int,int,int,track*)),this, SLOT(NewTrack(int,int,int,track*)));
    this->connect(&dc, SIGNAL(EndOfPlaylist()),this, SLOT(EndOfPlaylist()));
    this->connect(&dc, SIGNAL(TellTime(int,int,int)),this, SLOT(TellTime(int,int,int)));

    this->connect(this->dw->player, SIGNAL(Playing()),this, SLOT(Playing()));
    this->connect(this->dw->player, SIGNAL(Paused()),this, SLOT(Paused()));
    this->connect(this->dw->player, SIGNAL(Exiting()),this, SLOT(Exiting()));

    this->ui->twSongs->setColumnWidth(0,60);
    this->ui->twSongs->setColumnWidth(1,250);
    this->ui->twSongs->setColumnWidth(2,150);
    this->ui->twSongs->setColumnWidth(3,150);
    this->ui->twSongs->setColumnWidth(4,70);
    this->ui->twSongs->setColumnWidth(5,70);

    this->ui->twSongs->sortByColumn(0,Qt::AscendingOrder);

}

MainWindow::~MainWindow()
{
    delete ui;
    this->dw->Exit();
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_pushButton_5_clicked()
{

}

void MainWindow::on_pbLogin_clicked()
{


    /* Convert lineedit text to char* */
    QByteArray user = this->ui->leLogin->text().toLatin1();
    char *c_user = user.data();
    QByteArray pass = this->ui->lePassword->text().toLatin1();
    char *c_pass = pass.data();

    /* Try to authenticate */
    this->ui->lblLoginError->setText(tr("Authenticating..."));
    qApp->processEvents();

    if(!this->dw->Authenticate(c_user,c_pass)) {
        qDebug() << "Authentication failure";
        this->ui->lblLoginError->setText(tr("Incorrect credentials entered\nplease try again."));
    } else {

        qDebug() << "Authentication successful";

        /* Update playlists */
        this->ui->lblLoginError->setText(tr("Updating playlists..."));
        qApp->processEvents();

        this->dw->UpdatePlaylists();
    }
}

void MainWindow::PlaylistsUpdated() {

    qDebug() << "Received signal: PlaylistsUpdated";

    /* Show inside widget */
    this->ui->swWidgets->setCurrentWidget(this->ui->pgInside);

    /* Clear list */
    this->ui->cbPlaylists->clear();

    /* Insert all playlists in combo box */
    playlist* p = this->dw->GetPlaylists();
    if(p!=NULL){
        for (p; p; p = p->next)
        {
            if(p != NULL) {
                this->ui->cbPlaylists->addItem(QString::fromUtf8(p->name), QString::fromUtf8((char*)p->playlist_id));
                qDebug() << "Playlist_id: " << p->playlist_id;
            } else {
                qDebug() << "This really shouldn't happen... really...";
            }
        }
    }
}

void MainWindow::PrintTracks() {

    this->ui->twSongs->clear();

    track* head = this->dw->pending_list->tracks;
    int count=0;
    for (track* t = head; t; t = t->next) {
        if (t->has_meta_data) {
            //wrapper_wprintf(L"%3d: %-40s %2d:%02d ", count++, t->title,t->length / 60000, t->length % 60000 / 1000);
            QString t_artist;

            for (struct artist* a = t->artist; a; a = a->next)
                t_artist += QString().fromUtf8(a->name);

            QString t_song = QString().fromUtf8(t->title);
            QString t_length = QString("%1:%2").arg((int)(t->length / 60000),2,10,QChar('0')).arg((int)(t->length % 60000 / 1000),2,10,QChar('0'));
            QString t_album = QString().fromUtf8(t->album);
            QString t_popularity = QString().setNum(t->popularity);

            /* Check if song is playable */
            if(t->playable) {

                QTreeWidgetItem *t_item = new QTreeWidgetItem(this->ui->twSongs);
                t_item->setText(0, QString("%1").arg(count + 1,3,10,QChar(' ')));
                t_item->setText(1, t_song);
                t_item->setText(2, t_artist);
                t_item->setText(3, t_album);
                t_item->setText(4, t_length);
                int icon=(int)(t->popularity*10/2);
                if(icon>0&&icon<6) {
                    t_item->setIcon(5, QPixmap(QString(":/gfx/res/rating_%1.png").arg(icon)));
                    /*t_item->setText(5, QString().setNum(t_popularity,));
                    t_item->setForeground(5,t_item->backgroundColor(5));*/
                }
            }
        }
        count++;
    }
}

void MainWindow::on_pbShowPlaylist_clicked()
{
    qDebug() << "Show playlist button clicked";
    /* Iterate through all playlists */
    for (playlist* p = this->dw->GetPlaylists(); p; p = p->next)
    {
        if(QString((char*)p->playlist_id) == this->ui->cbPlaylists->itemData(this->ui->cbPlaylists->currentIndex())) {
            this->dw->pending_list = p;
            this->PrintTracks();
        }
    }
}

void MainWindow::on_twSongs_itemDoubleClicked(QTreeWidgetItem* item, int column)
{
    qDebug() << "Playing offset " << QString(item->text(0));
    if(this->dw->pending_list){
        this->dw->lastlist = this->dw->pending_list;
    }
    this->dw->Play(QString(item->text(0)).toInt()-1);
}

void MainWindow::on_pbSearch_clicked()
{
    QByteArray search = this->ui->leSearch->text().toLatin1();
    char *c_search = search.data();

    if(this->dw->Search(c_search))
        this->PrintTracks();
}

void MainWindow::on_pushButton_4_clicked()
{
    this->dw->PlayPrev();
}

void MainWindow::on_pushButton_3_clicked()
{
    this->dw->PlayNext();
}

void MainWindow::on_pushButton_2_clicked()
{

}

void MainWindow::on_pushButton_clicked()
{
    this->dw->player->PlayPause();
}

void MainWindow::NewTrack(int min, int sec, int totsec, track *t) {

    this->song_tot_len=totsec;
    this->ui->hsElapsed->setMaximum(totsec);

}
void MainWindow::EndOfPlaylist() {

    /* Force player to try to pley next song (=first song) */
    this->dw->PlayNext();

}

void MainWindow::TellTime(int min, int sec, int totsec) {

    int t_min = (int)this->song_tot_len/60;
    int t_sec = (int)this->song_tot_len%60;

    QString elapse;
    elapse = QString("%1:%2 / %3:%4").arg(min,2,10,QChar('0')).arg(sec,2,10,QChar('0')).arg(t_min,2,10,QChar('0')).arg(t_sec,2,10,QChar('0'));

    this->ui->lblElapsed->setText(elapse);
    this->ui->hsElapsed->setValue(totsec);

}

void MainWindow::Playing() {
    qDebug() << "Playing";
}

void MainWindow::Paused() {
    qDebug() << "Paused";
}

void MainWindow::Exiting() {
    qDebug() << "Exiting";
}

void MainWindow::on_cbPlaylists_activated(int index)
{

}

void MainWindow::on_cbPlaylists_currentIndexChanged(QString )
{

}

void MainWindow::on_cbPlaylists_currentIndexChanged(int index)
{

}
