#include "despotifyplay.h"

DespotifyPlay::DespotifyPlay(despotify_session* _ds,ao_device* _ao) {
    this->play_state = PAUSE;
    this->last_state = PAUSE;
    this->ao = _ao;
    this->ds = _ds;
}

void DespotifyPlay::PlayPause(void)
{
    this->mutex.lock();
    if(this->play_state==PLAY)
        this->play_state = PAUSE;
    else
        this->play_state = PLAY;
    this->mutex.unlock();
}

void DespotifyPlay::NewSong(despotify_session* ds, track* t, bool play_as_list) {
    this->mutex.lock();
    if(t&&t->playable) {
        despotify_stop(ds);
        this->usleep(250);
        despotify_play(ds, t, play_as_list);
        this->play_state = PLAY;
    } else {
        this->play_state = PAUSE;
    }
    this->mutex.unlock();
}

void DespotifyPlay::Pause()
{
    this->mutex.lock();
    this->play_state = PAUSE;
    this->mutex.unlock();
}

void DespotifyPlay::Exit(void)
{
    this->mutex.lock();
    despotify_stop(this->ds);
    despotify_exit(this->ds);
    this->usleep(100);
    this->play_state = EXIT;
    this->mutex.unlock();
}

void DespotifyPlay::run()
{

    pcm_data pcm;

    bool loop = true;
    while (loop) {

        /* Check for state changes and emit signals */
        if(this->play_state != this->last_state) {

            this->mutex.lock();

            switch (this->play_state) {
                case PAUSE: {
                    emit this->Paused();
                    qDebug() << "Emitting 1";
                    break;
                }
                case PLAY: {
                    emit this->Playing();
                    qDebug() << "Emitting 2";
                    break;
                }
                case EXIT: {
                    emit this->Exiting();
                    qDebug() << "Emitting 3";
                    break;
                }

            }

            this->last_state = this->play_state;

            this->mutex.unlock();

        }

        /* Do the regular stuff... */
        switch (this->play_state) {
            case PAUSE: {
                break;
            }

            case PLAY: {

                this->mutex.lock();
                if(!this->ds->dlabort) {
                    int rc = despotify_get_pcm(this->ds, &pcm);
                    if (rc == 0 && pcm.len > 0) {
                        audio_play_pcm(this->ao, &pcm);
                    } else {
                        qDebug() << "despotify_get_pcm() returned error " << rc;
                        exit(-1);
                    }
                } else {
                    qDebug() << "Skipping play due to dlabort";
                }
                this->mutex.unlock();

                break;
            }
            case EXIT: {
                loop = false;
                break;
            }
        }

        /* Give the system some time to think */
        DespotifyPlay::usleep( 250 );

    }
}
