#include <QDebug>
#include <list>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "despotifycallback.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    /* Initialize despotify */
    this->dw = new DespotifyWrap();
    qDebug() << "Is spotify initialized? " << this->dw->IsInitialized();

    /* Connect signals */
    this->connect(this->dw, SIGNAL(PlaylistsUpdated()),this, SLOT(PlaylistsUpdated()));
    this->connect(&dc, SIGNAL(NewTrack(int,int,int,track*)),this, SLOT(NewTrack(int,int,int,track*)));
    this->connect(&dc, SIGNAL(TellTime(int,int,int)),this, SLOT(TellTime(int,int,int)));
}

MainWindow::~MainWindow()
{
    delete ui;
    this->dw->Exit();
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_pushButton_5_clicked()
{

}

void MainWindow::on_pbLogin_clicked()
{
    /* Convert lineedit text to char* */
    QByteArray user = this->ui->leLogin->text().toLatin1();
    char *c_user = user.data();
    QByteArray pass = this->ui->lePassword->text().toLatin1();
    char *c_pass = pass.data();

    /* Try to authenticate */
    if(!this->dw->Authenticate(c_user,c_pass)) {
        this->ui->lblLoginError->setText(QString("Incorrect credentials entered\nplease try again."));
    } else {
        this->ui->lblLoginError->setText(QString(" "));

        /* Show inside widget */
        this->ui->swWidgets->setCurrentWidget(this->ui->pgInside);

        /* Update playlists */
        this->dw->UpdatePlaylists();
    }
}

void MainWindow::PlaylistsUpdated() {

    qDebug() << "Received signal: PlaylistsUpdated";

    /* Clear list */
    this->ui->cbPlaylists->clear();

    /* Insert all playlists in combo box */
    for (playlist* p = this->dw->GetPlaylists(); p; p = p->next)
    {
        this->ui->cbPlaylists->addItem(QString(p->name),QString((char*)p->playlist_id));
    }
}

void MainWindow::PrintTracks() {

    this->ui->twSongs->clear();

    track* head = this->dw->lastlist->tracks;
    int count=0;
    for (track* t = head; t; t = t->next) {
        if (t->has_meta_data) {
            //wrapper_wprintf(L"%3d: %-40s %2d:%02d ", count++, t->title,t->length / 60000, t->length % 60000 / 1000);
            QString t_artist = QString("");

            for (struct artist* a = t->artist; a; a = a->next)
                t_artist += a->name;
            t_artist = t_artist.toLatin1();
            QString t_song = QString(t->title).toLatin1();
            QString t_length = QString().setNum((int)(t->length / 60000)) + QString(":") + QString().setNum((int)(t->length % 60000 / 1000));
            QString t_album = QString(t->album).toLatin1();
            QString t_popularity = QString().setNum(t->popularity);

            /* Check if song is playable */
            if(t->playable) {

                QTreeWidgetItem *t_item = new QTreeWidgetItem(this->ui->twSongs);
                t_item->setText(0, QString("").setNum(count));
                t_item->setText(1, t_song);
                t_item->setText(2, t_artist);
                t_item->setText(3, t_album);
                t_item->setText(4, t_length);
                t_item->setText(5, t_popularity);
            }
        }
        count++;
    }
}

void MainWindow::on_cbPlaylists_currentIndexChanged(int index)
{
    qDebug() << "Deprecated shit";
}


void MainWindow::on_cbPlaylists_activated(int index)
{
    qDebug() << "Deprecated shit 2";
}

void MainWindow::on_pbShowPlaylist_clicked()
{
    qDebug() << "Show playlist button clicked";
    /* Iterate through all playlists */
    for (playlist* p = this->dw->GetPlaylists(); p; p = p->next)
    {
        /* ToDo : Use ID */
        if(QString((char*)p->name) == this->ui->cbPlaylists->currentText()) {
            qDebug() << "Print tracks";
            this->dw->lastlist = p;
            this->PrintTracks();
        }
    }
}

void MainWindow::on_twSongs_itemDoubleClicked(QTreeWidgetItem* item, int column)
{
    qDebug() << "Playing offset " << QString(item->text(0));
    this->dw->Play(QString(item->text(0)).toInt());
}

void MainWindow::on_pbSearch_clicked()
{
    QByteArray search = this->ui->leSearch->text().toLatin1();
    char *c_search = search.data();

    if(this->dw->Search(c_search))
        this->PrintTracks();
}

void MainWindow::on_pushButton_4_clicked()
{
    this->dw->PlayPrev();
}

void MainWindow::on_pushButton_3_clicked()
{
    this->dw->PlayNext();
}
void MainWindow::on_pushButton_2_clicked()
{

}

void MainWindow::on_pushButton_clicked()
{
    this->dw->player->PlayPause();
}

void MainWindow::NewTrack(int min, int sec, int totsec, track *t) {

    this->song_tot_len=totsec;
    this->ui->hsElapsed->setMaximum(totsec);

}

void MainWindow::TellTime(int min, int sec, int totsec) {

    int t_min = (int)this->song_tot_len/60;
    int t_sec = (int)this->song_tot_len%60;

    QString elapse;
    elapse = QString().setNum(min) + QString(":") + QString().setNum(sec) + QString(" / ") + QString().setNum(t_min) + QString(":") + QString().setNum(t_sec);

    this->ui->lblElapsed->setText(elapse);
    this->ui->hsElapsed->setValue(totsec);

}

