#include <QWidget>
#include <QMessageBox>
#include <QString>

#ifdef Q_WS_MAEMO_5
#   include <QtMaemo5/QMaemo5InformationBox>
#endif

#include "utils.h"

void showMessage(QWidget *parent, const QString &msg, MSG_TYPE msgType)
{
#ifdef Q_WS_MAEMO_5
    QString sp("\n\n");
    QMaemo5InformationBox::information(parent, sp + msg + sp, QMaemo5InformationBox::NoTimeout);
#else
    switch (msgType)
    {
        case MSG_INFO:
            QMessageBox::information(parent, ("Qthello"), msg);
            break;
        case MSG_WARNING:
            QMessageBox::warning(parent, ("Qthello"), msg);
            break;
        case MSG_ERROR:
            QMessageBox::critical(parent, ("Qthello"), msg);
            break;
    }//switch
#endif
}
