#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>

#include "pixmaps/WhiteCell.xpm"
#include "pixmaps/BlackCell.xpm"

#include "infopanel.h"
#include "reversigame.h"

InfoPanel::InfoPanel(const ReversiGame &reversiGame, QWidget *parent) :
    QWidget(parent),
    reversiGame_(reversiGame)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->addStretch(1);

    QHBoxLayout *hlayout = new QHBoxLayout();
    //hlayout->addStretch(1);
    QLabel *lb = new QLabel(this);
    lb->setPixmap(WhiteCell_xpm);
    hlayout->addWidget(lb);
    lbWhite = new QLabel("2", this);
    hlayout->addWidget(lbWhite);
    hlayout->addStretch(1);

    lb = new QLabel(this);
    lb->setPixmap(BlackCell_xpm);
    hlayout->addWidget(lb);
    lbBlack = new QLabel("2", this);
    hlayout->addWidget(lbBlack);
    hlayout->addStretch(1);

    layout->addLayout(hlayout);

    hlayout = new QHBoxLayout();
    hlayout->addStretch(1);
    lbTurnMsg = new QLabel(tr("Black turn"), this);
    hlayout->addWidget(lbTurnMsg);
    hlayout->addStretch(1);

    layout->addItem(hlayout);

    setLayout(layout);

    connect(&reversiGame_, SIGNAL(updateInfo()), this, SLOT(slotStepComplete()) );
    connect(&reversiGame_, SIGNAL(newGame(bool)), this, SLOT(slotStepComplete()) );
}

void InfoPanel::setInfo()
{
    static const char *players[] = {QT_TR_NOOP("White"), QT_TR_NOOP("Black")};
    QString turnInfo;
    turnInfo = QString(tr("%1 turn")).arg(tr(players[reversiGame_.currentPlayer()]));
    lbTurnMsg->setText(turnInfo);
    lbTurnMsg->update();
    lbWhite->setNum(int(reversiGame_.score(White)));
    lbWhite->update();
    lbBlack->setNum(int(reversiGame_.score(Black)));
    lbBlack->update();
}

void InfoPanel::slotStepComplete()
{
    setInfo();
}
