#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QCheckBox>
#include <QComboBox>
#include <QDialogButtonBox>

#include "optionsdialog.h"
#include "qthellosettings.h"

OptionsDialog::OptionsDialog(QthelloSettings *settings, QWidget *parent):
    QDialog(parent),
    settings_(settings)
{
    QVBoxLayout *topLayout = new QVBoxLayout(this);

    QLabel *lb = new QLabel(tr("Animation speed:"), this);
    topLayout->addWidget(lb);
    cbAnimationSpeed_ = new QComboBox(this);
    cbAnimationSpeed_->addItem(tr("No animation"));
    cbAnimationSpeed_->addItem(tr("Slow"));
    cbAnimationSpeed_->addItem(tr("Medium"));
    cbAnimationSpeed_->addItem(tr("Fast"));
    cbAnimationSpeed_->setCurrentIndex(settings_->animationSpeed());

    topLayout->addWidget(cbAnimationSpeed_);
    chbSaveMode_ = new QCheckBox(tr("&Save mode on exit"), this);
    chbSaveMode_->setChecked(settings_->saveMode());
    topLayout->addWidget(chbSaveMode_);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    topLayout->addWidget(buttonBox);

    connect(buttonBox, SIGNAL(accepted()), this, SLOT(slotOk()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

void OptionsDialog::slotOk()
{
    settings_->setAnimationSpeed(cbAnimationSpeed_->currentIndex());
    settings_->setSaveMode(chbSaveMode_->isChecked());
    accept();
}
