#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QMessageBox>
#include <QtGui>
#ifdef Q_WS_MAEMO_5
#   include <QtMaemo5/QMaemo5InformationBox>
#endif

#include "mainwindow.h"
#include "centralwidget.h"
#include "utils.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    setWindowTitle(tr("Qthello"));
    centralWdgt = new CentralWidget(this, reversiGame_);
    setCentralWidget(centralWdgt);
    createMenuToolbar();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(slotOrientationChanged()));
    connect(&reversiGame_, SIGNAL(gameOver()), SLOT(slotGameOver()));

    slotNewGame();
}

MainWindow::~MainWindow()
{

}

void MainWindow::createMenuToolbar()
{
    QMenu *mn  = menuBar()->addMenu(tr("&Game"));
    QAction *a = mn->addAction(tr("&New game"));
    a->setShortcut(Qt::CTRL + Qt::Key_N);
    connect(a, SIGNAL(triggered()), this, SLOT(slotNewGame()));
    mn->addSeparator();

    a = mn->addAction(tr("E&xit"));
    a->setShortcut(Qt::ALT + Qt::Key_X);
    connect(a, SIGNAL(triggered()), this, SLOT(close()));

    mn = menuBar()->addMenu(tr("&Help"));
    a = mn->addAction(tr("&About..."));
    connect(a, SIGNAL(triggered()), this, SLOT(slotAbout()));
}

void MainWindow::slotNewGame()
{
    centralWdgt->newGame();
}

void MainWindow::slotGameOver()
{
    QString info;
    info = QString(tr("Game over!\n White player %1; Black player %2.")).arg(reversiGame_.score(White)).arg(reversiGame_.score(Black));
    showMessage(this, info);
    slotNewGame();
}

void MainWindow::slotOrientationChanged()
{
    centralWdgt->showInfoPanels();
}

void MainWindow::slotAbout()
{
    QMessageBox::about(this, tr("About Qthello"), tr("Othello/Reversi game\n\n"
                                "General programming - (c) 2010 Vadim Khohlov <xvadima@ukr.net>\n\n"
                                "Images - GPE-Othello project (c) 2007 Joseph J. McCarthy <mccarthy@granular.che.pitt.edu>\n\n"
                                "AI Engine - KReversi project (c) 1997-2000, Mario Weilguni\n(c) 2004-2006, Inge Wallin\n(c) 2006, Dmitry Suzdalev"));
}
