#ifndef REVERSISCENE_H
#define REVERSISCENE_H

#include <QGraphicsScene>

#include "reversidefs.h"

class ReversiGame;
class QWidget;

class ReversiScene : public QGraphicsScene
{
    Q_OBJECT
public:
    ReversiScene(ReversiGame &reversiGame, QWidget *mainWin);
    int fieldWidth() const { return fieldWidth_; }
    int fieldHeight() const { return fieldHeight_; }

public slots:
    void syncBoard();

signals:
    void gameOver();
    void stepUnavailable();

private:
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

private slots:
    void slotStepComplete();
    void slotNewGame();

private:
    ReversiGame &reversiGame_;
    ChipColor   currentPlayer_;

    int cellWidth_;
    int cellHeight_;
    int fieldWidth_;
    int fieldHeight_;
};

#endif // REVERSISCENE_H
