#include "reversiitem.h"

#include "pixmaps/EmptyCell.xpm"
#include "pixmaps/WhiteCell.xpm"
#include "pixmaps/BlackCell.xpm"

ReversiItem::ReversiItem(QGraphicsScene *scene):
        QGraphicsPixmapItem(0, scene)
{
    chipPixmaps_[White] = QPixmap(WhiteCell_xpm);
    chipPixmaps_[Black] = QPixmap(BlackCell_xpm);
    chipPixmaps_[Empty] = QPixmap(EmptyCell_xpm);

    setColor(Empty);
}

void ReversiItem::setColor(ChipColor c)
{
    setPixmap(chipPixmaps_[c]);
}
