#include <QVBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QComboBox>

#include "modepanel.h"

ModePanel::ModePanel(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout *layout = new QVBoxLayout(this);

    QGridLayout *hlayout = new QGridLayout();

    QLabel *lbMode = new QLabel("Mode: ", this);
    hlayout->addWidget(lbMode, 0, 0);
    QLabel *lbStrength = new QLabel("AI level: ", this);
    hlayout->addWidget(lbStrength, 1, 0);

    cbMode_ = new QComboBox(this);
    cbMode_->addItem("Human vs human");
    cbMode_->addItem("Human vs computer");
    cbMode_->addItem("Computer vs human");
    cbMode_->setCurrentIndex(1);
    hlayout->addWidget(cbMode_, 0, 1);

    cbStrength_ = new QComboBox(this);
    cbStrength_->addItem("Very easy");
    cbStrength_->addItem("Easy");
    cbStrength_->addItem("Medium");
    cbStrength_->addItem("Hard");
    cbStrength_->addItem("Very hard");
    cbStrength_->addItem("Extremely hard");
    cbStrength_->addItem("Impossible");
    cbStrength_->setCurrentIndex(2);
    hlayout->addWidget(cbStrength_, 1, 1);

    layout->addItem(hlayout);
    setLayout(layout);
}

QPair<int, int>
ModePanel::mode() const
{
    return QPair<int, int>(cbMode_->currentIndex(), cbStrength_->currentIndex());
}
