#include <QtGui/QPainter>
#include <QMouseEvent>

//#include "pixmaps/EmptyCell.xpm"
//#include "pixmaps/WhiteCell.xpm"
//#include "pixmaps/BlackCell.xpm"

#include "fieldview.h"
#include "reversigame.h"
#include "reversiscene.h"


FieldView::FieldView(ReversiGame &reversiGame, QWidget *parent) :
    QGraphicsView(parent),
    reversiGame_(reversiGame)
{
    scene_ = new ReversiScene(reversiGame_, parent->parentWidget());
    setScene(scene_);
    scene_->syncBoard();

    setMinimumSize(scene_->fieldWidth(), scene_->fieldHeight());
    setMaximumSize(scene_->fieldWidth(), scene_->fieldHeight());

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setFrameStyle(QFrame::NoFrame);

    //connect(scene_, SIGNAL(gameOver()), parent->parentWidget(), SLOT(slotGameOver()));
}

QSize FieldView::sizeHint () const
{
    return QSize(scene_->fieldWidth(), scene_->fieldHeight());
}
