//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include <QtGui/QApplication>
#include <QDebug>
#include <QDir>
#include <QTranslator>
#include "mainwindow.h"
#include "widgetmanager.h"
#include "qtsingleapplication/qtsingleapplication.h"
#include "commonstatic.h"
#include <iostream>

void SimpleLoggingHandler(QtMsgType type, const char *msg)
{
    if (!CommonStatic::Debug)
        return;

    switch (type) {
        case QtDebugMsg:
            std::cout << "Debug: " << msg << std::endl;
            break;
        case QtCriticalMsg:
            std::cout  << "Critical: " << msg << std::endl;
            break;
        case QtWarningMsg:
            std::cout  << "Warning: " << msg << std::endl;
            break;
        case QtFatalMsg:
            std::cout  << "Fatal: " << msg << std::endl;
            abort();
    }
}

int main(int argc, char *argv[])
{
    CommonStatic::Debug = false;
    if (argc > 1 && QString(argv[1]) == "-d")
        CommonStatic::Debug = true;

    QtSingleApplication app(argc, argv);
    app.setApplicationName("qtBatteryWidget");
    app.setOrganizationName("sakya");
    app.setApplicationVersion(QUOTE(APP_VERSION));
    qInstallMsgHandler(SimpleLoggingHandler);

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        qDebug() << "Asking to create a new widget.";
        app.sendMessage(MESSAGE_ADD_WIDGET);
        return 0;
    }

    QString locale = QLocale::system().name();
    QTranslator translator;
    if (translator.load(QString(":/qtbatterywidget_%1").arg(locale)))
        app.installTranslator(&translator);

    CommonStatic::CurrentSettings = new Settings();
    CommonStatic::CurrentSettings->Load();

    WidgetManager* manager = new WidgetManager(NULL);
    QObject::connect(&app, SIGNAL(messageReceived(const QString&)), manager, SLOT(receiveMessage(const QString&)));

    QString folder = CommonStatic::GetSettingsFolder();
    if (!QDir().exists(folder))
        QDir().mkdir(folder);

    WidgetManager::RestoreWidgets();

    return app.exec();
}
