/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Messaging Framework.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "service.h"
#ifndef QMF_NO_MESSAGE_SERVICE_EDITOR
#include "settings.h"
#endif
#include <QtPlugin>
#include <QCoreApplication>

namespace { const QString serviceKey("qtopiamailfile"); }


class QtopiamailfileConfigurator : public QMailMessageServiceConfigurator
{
public:
    QtopiamailfileConfigurator();
    ~QtopiamailfileConfigurator();

    virtual QString service() const;
    virtual QString displayName() const;

#ifndef QMF_NO_MESSAGE_SERVICE_EDITOR
    virtual QMailMessageServiceEditor *createEditor(QMailMessageServiceFactory::ServiceType type);
#endif
};

QtopiamailfileConfigurator::QtopiamailfileConfigurator()
{
}

QtopiamailfileConfigurator::~QtopiamailfileConfigurator()
{
}

QString QtopiamailfileConfigurator::service() const
{
    return serviceKey;
}

QString QtopiamailfileConfigurator::displayName() const
{
    return QCoreApplication::instance()->translate("QMailMessageService", "Mailfile");
}

#ifndef QMF_NO_MESSAGE_SERVICE_EDITOR
QMailMessageServiceEditor *QtopiamailfileConfigurator::createEditor(QMailMessageServiceFactory::ServiceType type)
{
    if (type == QMailMessageServiceFactory::Storage)
        return new QtopiamailfileSettings;

    return 0;
}
#endif

#ifdef Q_WS_MAEMO5
#  define MY_PLUGIN_VERIFICATION_DATA \
	            static const char *my_plugin_verification_data = \
      "pattern=""QT_PLUGIN_VERIFICATION_DATA""\n" \
      "version="QT_VERSION_STR"\n" \
      "debug="QPLUGIN_DEBUG_STR"\n" \
      "buildkey=""armv6 linux g++-4 full-config";

#  define MY_EXPORT_PLUGIN2(PLUGIN, PLUGINCLASS)      \
	                    MY_PLUGIN_VERIFICATION_DATA \
            Q_EXTERN_C Q_DECL_EXPORT \
            const char * Q_STANDARD_CALL qt_plugin_query_verification_data() \
            { return my_plugin_verification_data; } \
            Q_EXTERN_C Q_DECL_EXPORT QT_PREPEND_NAMESPACE(QObject) * Q_STANDARD_CALL qt_plugin_instance() \
            Q_PLUGIN_INSTANCE(PLUGINCLASS)

/* Adding plugin debug string */
#ifdef QPLUGIN_DEBUG_STR
#    undef QPLUGIN_DEBUG_STR
#endif
MY_EXPORT_PLUGIN2(qtopiamailfile,QtopiamailfileServicePlugin)
#else
Q_EXPORT_PLUGIN2(qtopiamailfile,QtopiamailfileServicePlugin)
#endif

QtopiamailfileServicePlugin::QtopiamailfileServicePlugin()
    : QMailMessageServicePlugin()
{
}

QString QtopiamailfileServicePlugin::key() const
{
    return serviceKey;
}

bool QtopiamailfileServicePlugin::supports(QMailMessageServiceFactory::ServiceType type) const
{
    return (type == QMailMessageServiceFactory::Storage);
}

bool QtopiamailfileServicePlugin::supports(QMailMessage::MessageType) const
{
    return true;
}

QMailMessageService *QtopiamailfileServicePlugin::createService(const QMailAccountId &)
{
    return 0;
}

QMailMessageServiceConfigurator *QtopiamailfileServicePlugin::createServiceConfigurator()
{
    return new QtopiamailfileConfigurator();
}


