/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QSENSORFACTORY_H
#define QSENSORFACTORY_H

#include "qsensor.h"
#include <QList>

QTM_BEGIN_NAMESPACE

class Q_SENSORS_EXPORT QSensorFactory
{
public:
    // Get the singleton instance
    static QSensorFactory *instance();

    // Get a sensor
    QByteArray defaultSensorForType(const QByteArray &type) const;

    // If there are multiple sensors for a type...
    QList<QByteArray> sensorsForType(const QByteArray &type) const;

    // Get all sensors on the device. Not sure why you'd want to
    // do this unless you were telling the user what sensors are
    // available.
    QList<QByteArray> sensorList() const;

    // Get all sensor types on the device. Not sure why you'd want to
    // do this unless you were telling the user what sensors are
    // available.
    QList<QByteArray> sensorTypes() const;

    // Create a sensor.
    QSensor *createSensor(const QByteArray &identifier) const;
};

QTM_END_NAMESPACE

#endif

