/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Components project on Qt Labs.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions contained
** in the Technology Preview License Agreement accompanying this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
****************************************************************************/

#ifndef QTDECLARATIVETOPLEVELITEM_H
#define QTDECLARATIVETOPLEVELITEM_H

#include <QtDeclarative/qdeclarativeitem.h>

#include <kernel/common.h>

class QMxTopLevelItemPrivate;
class QMxTopLevelItem : public QDeclarativeItem
{
    Q_OBJECT
    Q_PROPERTY(bool keepInside READ keepInside WRITE setKeepInside NOTIFY keepInsideChanged);

public:
    QMxTopLevelItem(QDeclarativeItem *parent = 0);
    virtual ~QMxTopLevelItem();

    bool keepInside() const;
    void setKeepInside(bool keepInside);

Q_SIGNALS:
    void keepInsideChanged(bool keepInside);

protected:
    QMxTopLevelItem(QMxTopLevelItemPrivate &dd, QDeclarativeItem *parent = 0);

    virtual QVariant itemChange(GraphicsItemChange change, const QVariant &value);

    QScopedPointer<QMxTopLevelItemPrivate> d_ptr;

private:
    Q_DISABLE_COPY(QMxTopLevelItem);
    Q_DECLARE_PRIVATE(QMxTopLevelItem);
};

QML_DECLARE_TYPE(QMxTopLevelItem)

#endif // QTDECLARATIVETOPLEVELITEM_H
