/*
 * Copyright (C) 2017 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QCHTRANSFERMANAGER_H
#define QCHTRANSFERMANAGER_H

#include <QObject>

class QchTransferManagerPrivate;

class QchTransferManager : public QObject
{
    Q_OBJECT
    
    Q_PROPERTY(int count READ count NOTIFY countChanged)
    Q_PROPERTY(int maximumConcurrentTransfers READ maximumConcurrentTransfers WRITE setMaximumConcurrentTransfers
               NOTIFY maximumConcurrentTransfersChanged)
    
public:
    static QchTransferManager* instance();
    
    int count() const;
    
    int maximumConcurrentTransfers() const;
    void setMaximumConcurrentTransfers(int maximum);

Q_SIGNALS:
    void countChanged(int count);
    void maximumConcurrentTransfersChanged(int maximum);
    
private:
    QchTransferManager();
    ~QchTransferManager();
    
    QScopedPointer<QchTransferManagerPrivate> d_ptr;
    
    Q_DECLARE_PRIVATE(QchTransferManager)
    
    Q_DISABLE_COPY(QchTransferManager)
};

#endif // QCHTRANSFERMANAGER_H
