/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SCREENSHOT_P_H
#define SCREENSHOT_P_H

class ScreenShot
{
    Q_OBJECT

    Q_PROPERTY(Item target READ target WRITE setTarget)
    Q_PROPERTY(string fileName READ fileName WRITE setFileName)
    Q_PROPERTY(bool overwriteExistingFile READ overwriteExistingFile WRITE setOverwriteExistingFile)
    Q_PROPERTY(bool smooth READ smooth WRITE setSmooth)
    Q_PROPERTY(int width READ width WRITE setWidth RESET resetWidth)
    Q_PROPERTY(int height READ height WRITE setHeight RESET resetHeight)
    Q_PROPERTY(int targetX READ targetX WRITE setTargetX)
    Q_PROPERTY(int targetY READ targetY WRITE setTargetY)
    Q_PROPERTY(int targetWidth READ targetWidth WRITE setTargetWidth)
    Q_PROPERTY(int targetHeight READ targetHeight WRITE setTargetHeight)

public:
    bool grab();

/*!
    \class ScreenShot
    \brief The ScreenShot component grabs an snapshot from the screen and 
    saves it to a file
    
    \ingroup org-hildon-utils
    
    \code
    Page {
        id: page
        
        windowTitle: "Screen shot page"
        
        Button {
            anchors.centerIn: parent
            text: "Take screen shot"
            onClicked: screenshot.grab()
        }
        
        ScreenShot {
            id: screenshot
            
            target: page // Take a screen shot of this page
            fileName: "/home/user/MyDocs/.images/ScreenShots/qml-screenshot.png"
            overwriteExistingFile: true
        }
    }
    \endcode
*/

/*!
    \property Item ScreenShot::target
    \brief The item of which a screen shot will be saved
    
    The default value is \c null, meaning the screen shot will 
    be of the entire screen.
*/

/*!
    \property string ScreenShot::fileName
    \brief The file to which the screen shot will be saved
*/

/*!
    \property bool ScreenShot::overwriteExistingFile
    \brief Whether an existing file will be overwritten when a 
    screen shot is saved
    
    The default value is false, meaning that the screen shot will 
    be saved to a file with "($NUMBER)" inserted before the file suffix.
*/

/*!
    \property bool ScreenShot::smooth
    \brief Whether smooth scaling should be used when saving 
    the screen shot
    
    \sa width, height
*/

/*!
    \property int ScreenShot::width
    \brief The width to be used when scaling the screen shot
    
    By default, the screen shot is not scaled.
    
    \sa height, smooth
*/

/*!
    \property int ScreenShot::height
    \brief The height to be used when scaling the screen shot
    
    By default, the screen shot is not scaled.
    
    \sa width, smooth
*/

/*!
    \property int ScreenShot::targetX
    \brief The x coordinate from where the screen shot will be taken
    
    The default value is 0.
    
    \sa targetX
*/

/*!
    \property int ScreenShot::targetY
    \brief The y coordinate from where the screen shot will be taken
    
    The default value is 0.
    
    \sa targetY
*/

/*!
    \property int ScreenShot::targetWidth
    \brief The number of pixels to be grabbed horizontally
    
    The default value is equal to the width of \link target\endlink.
*/

/*!
    \property int ScreenShot::targetHeight
    \brief The number of pixels to be grabbed vertically
    
    The default value is equal to the height of \link target\endlink.
*/

/*!
    \fn bool ScreenShot::grab()
    
    Takes a screen shot of \link target\endlink, and returns true 
    if the screen shot is successfully saved to \link fileName\endlink.
*/

};

#endif // SCREENSHOT_P_H
