/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef QMLGCONFITEM_P_H
#define QMLGCONFITEM_P_H

class GConfItem
{
    Q_OBJECT
    
    Q_PROPERTY(string key READ key WRITE setKey NOTIFY keyChanged FINAL)
    Q_PROPERTY(variant value READ value WRITE setValue RESET resetValue NOTIFY valueChanged FINAL)
    Q_PROPERTY(stringlist childDirectories READ childDirectories NOTIFY keyChanged FINAL)
    Q_PROPERTY(stringlist childEntries READ childEntries NOTIFY keyChanged FINAL)
    
signals:
    void subtreeChanged(string key, variant value);
    
/*!
    \class GConfItem
    \brief The GConfItem component enables access to GConf keys in QML
    
    \ingroup org-hildon-settings
*/

/*!
    \property string GConfItem::key
    \brief The GConf key
*/

/*!
    \property variant GConfItem::value
    \brief The value associated with the \link key\endlink
*/

/*!
    \property stringlist GConfItem::childDirectories
    \brief The directories under the \link key\endlink
*/

/*!
    \property stringlist GConfItem::childEntries
    \brief The entries under the \link key\endlink
*/

/*!
    \fn void GConfItem::subtreeChanged(string key, variant value)
    
    This signal is emitted when an entry under the \link key\endlink 
    changes. The changed \c key is passed along with its new \c value.
*/

};

#endif // QMLGCONFITEM_P_H
