/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DBUSADAPTOR_P_H
#define DBUSADAPTOR_P_H

class DBusAdaptor
{

    Q_PROPERTY(enumeration bus READ bus WRITE setBus)
    Q_PROPERTY(string serviceName READ serviceName WRITE setServiceName)
    Q_PROPERTY(string path READ path WRITE setPath)
    Q_PROPERTY(Object target READ target WRITE setTarget RESET resetTarget)

/*!
    \class DBusAdaptor
    \brief The DBusAdaptor component registers a target object with DBus
    
    \ingroup org-hildon-dbus
    
    \code
    Window {
        id: window
        
        DBusAdaptor {
            id: adaptor
            
            serviceName: "org.hildon.dbus.MyApplication"
            path: "/org/hildon/dbus"
            target: window
        }
    }
    \endcode
    
    \code
    $ dbus-send --type=method_call --print-reply --dest=org.hildon.dbus.MyApplication /org/hildon/dbus 
    org.hildon.dbus.MyApplication.show // Shows the window
    \endcode
    
    \note DBusAdaptor cannot currently register functions defined in JavaScript.
*/

/*!
    \property enumeration DBusAdaptor::bus
    \brief The bus on which the target is registered
    
    The possible values are:
    
    \li \c SessionBus
    \li \c SystemBus
    
    The default value is \c SessionBus.
*/

/*!
    \property string DBusAdaptor::serviceName
    \brief The DBus service on which the target is registered
*/

/*!
    \property string DBusAdaptor::path
    \brief The DBus path on which the target is registered
*/

/*!
    \property Object DBusAdaptor::target
    \brief The target object to be registered
    
    When setting this property, any existing target object
    is unregistered. Set the property to \c null to 
    reset the target.
*/

};

#endif // DBUSADAPTOR_P_H
