/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TOOLBUTTON_P_H
#define TOOLBUTTON_P_H

class ToolButton : public Button
{

    Q_PROPERTY(enumeration popupMode READ popupMode WRITE setPopupMode)
    Q_PROPERTY(enumeration toolButtonStyle READ toolButtonStyle WRITE setToolButtonStyle)
    Q_PROPERTY(bool autoRaise READ autoRaise WRITE setAutoRaise)
    Q_PROPERTY(enumeration arrowType READ arrowType WRITE setArrowType)

signals:
    void triggered(Action action);
    
/*!
    \class ToolButton
    \brief The ToolButton component provides a quick-access button to
    commands or options, usually used inside a ToolBar.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls

    A tool button is a special button that provides quick-access to
    specific commands or options. As opposed to a normal command
    button, a tool button usually doesn't show a text label, but shows
    an icon instead.
    
    \sa ToolBar, Action
*/

/*!
    \property enumeration ToolButton::toolButtonStyle
    \brief Whether the tool button displays an icon only, text only,
    or text beside/below the icon.
    
    The possible values are:
    
    \li \c Qt.ToolButtonIconOnly - Only display the icon.
    \li \c Qt.ToolButtonTextOnly - Only display the text.
    \li \c Qt.ToolButtonTextBesideIcon - The text appears beside the icon.
    \li \c Qt.ToolButtonTextUnderIcon - The text appears under the icon.

    The default is Qt.ToolButtonIconOnly.
*/

/*!
    \property enumeration ToolButton::arrowType
    \brief Whether the button displays an arrow instead of a normal icon

    The possible values are:
    
    \li \c Qt.NoArrow
    \li \c Qt.UpArrow
    \li \c Qt.DownArrow
    \li \c Qt.LeftArrow
    \li \c Qt.RightArrow

    By default, this property is set to Qt.NoArrow.
*/

/*!
    \property enumeration ToolButton::popupMode
    \brief Describes the way that popup menus are used with tool buttons
    
    Possible values are:
    
    \li \c DelayedPopup - The menu is displayed after pressing and 
    holding the tool button down for a certain amount of time.
    
    \li \c MenuButtonPopup - In this mode the tool button displays a 
    special arrow to indicate that a menu is present. The menu is 
    displayed when the arrow part of the button is pressed.
    
    \li \c InstantPopup - The menu is displayed, without delay, 
    when the tool button is pressed. In this mode, the button's 
    own action is not triggered.

    By default, this property is set to \c DelayedPopup.
*/

/*!
    \property bool ToolButton::autoRaise
    \brief Whether auto-raising is enabled or not.

    The default is disabled (i.e. false).
*/

/*!
    \fn void ToolButton::triggered(Action action)

    This signal is emitted when the given \a action is triggered.

    The action may also be associated with other parts of the user interface,
    such as menu items and keyboard shortcuts. Sharing actions in this
    way helps make the user interface more consistent and is often less work
    to implement.
*/

};

#endif // TOOLBUTTON_P_H
