/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TOOLBAR_P_H
#define TOOLBAR_P_H

class ToolBar : public Item
{

    Q_PROPERTY(bool movable READ isMovable WRITE setMovable)
    Q_PROPERTY(flags allowedAreas READ allowedAreas WRITE setAllowedAreas)
    Q_PROPERTY(enumeration orientation READ orientation WRITE setOrientation)
    Q_PROPERTY(size iconSize READ iconSize WRITE setIconSize)
    Q_PROPERTY(enumeration toolButtonStyle READ toolButtonStyle WRITE setToolButtonStyle)
    
signals:
    void actionTriggered(Action action);
    
/*!
    \class ToolBar

    \brief The ToolBar component provides a movable panel that contains a
    set of controls.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls


    Toolbar buttons are added by adding \e actions. Groups of buttons can be 
    separated using by inserting a Separator. If a toolbar button is not
    appropriate, an item can be inserted instead; examples of suitable items 
    are SpinBox and DoubleSpinBox. When a toolbar button is pressed it
    emits the actionTriggered() signal.

    A toolbar can be fixed in place in a particular area (e.g. at the
    top of the window), or it can be movable between
    toolbar areas.

    When a toolbar is resized in such a way that it is too small to
    show all the items it contains, an extension button will appear as
    the last item in the toolbar. Pressing the extension button will
    pop up a menu containing the items that does not currently fit in
    the toolbar.

    When a ToolBar is not a child of a Window or Page, it loses the ability
    to populate the extension pop up with items added to the toolbar. 
    Please use ItemAction instead.

    \sa ToolButton, Menu, Action
*/

/*! \property bool ToolBar::movable
    \brief Whether the user can move the toolbar within the toolbar area,
    or between toolbar areas

    By default, this property is true.

    This property only makes sense if the toolbar is in a
    Window or Page.

    \sa allowedAreas
*/

/*!
    \property flags ToolBar::allowedAreas
    \brief Areas where the toolbar may be placed
    
    Possible values are:
    
    \li \c Qt.LeftToolBarArea
    \li \c Qt.RightToolBarArea
    \li \c Qt.TopToolBarArea
    \li \c Qt.BottomToolBarArea
    \li \c Qt.AllToolBarAreas
    \li \c Qt.NoToolBarArea

    The default is Qt.AllToolBarAreas.

    This property only makes sense if the toolbar is in a
    Window or Page.

    \sa movable
*/

/*! \property enumeration ToolBar::orientation
    \brief Orientation of the toolbar
    
    Possible values are:
    
    \li \c Qt.Horizontal
    \li \c Qt.Vertical

    The default is Qt.Horizontal.
*/

/*!
    \property size ToolBar::iconSize
    \brief Size of icons in the toolbar.

    This is the maximum size an icon can have. 
    Icons of smaller size will not be scaled up.
*/

/*!
    \property enumeration ToolBar::toolButtonStyle
    \brief The style of toolbar buttons

    The possible values are:
    
    \li \c Qt.ToolButtonIconOnly - Only display the icon.
    \li \c Qt.ToolButtonTextOnly - Only display the text.
    \li \c Qt.ToolButtonTextBesideIcon - The text appears beside the icon.
    \li \c Qt.ToolButtonTextUnderIcon - The text appears under the icon.

    The default is Qt.ToolButtonIconOnly.
*/

/*!
    \fn void ToolBar::actionTriggered(Action action)

    This signal is emitted when an action in this toolbar is triggered.
    This happens when the action's tool button is pressed, or when the
    action is triggered in some other way outside the tool bar. The parameter
    holds the triggered \a action.
*/

};

#endif // TOOLBAR_P_H
