/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TEXTEDITSTYLE_P_H
#define TEXTEDITSTYLE_P_H

class TextEditStyle : public FlickableStyle
{
    
    Q_PROPERTY(color selectionBackgroundColor READ selectionBackgroundColor WRITE setSelectionBackgroundColor)
    Q_PROPERTY(color selectionColor READ selectionColor WRITE setSelectionColor)
    
/*!
    \class TextEditStyle
    \brief TextEditStyle is a styling component for TextEdit
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa TextEdit
*/

/*!
    \property color TextEditStyle::selectionBackgroundColor
    \brief Sets the background color of selected text in the TextEdit
*/

/*!
    \property color TextEditStyle::selectionColor
    \brief Sets the color of selected text in the TextEdit
*/

};

#endif // TEXTEDITSTYLE_P_H

