/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TABGROUP_P_H
#define TABGROUP_P_H

class TabGroup : public Item
{

    Q_PROPERTY(Item currentTab READ currentTab WRITE setCurrentTab)
    Q_PROPERTY(int currentIndex READ currentIndex WRITE setCurrentIndex)
    Q_PROPERTY(int count READ count)

/*!
    \class TabGroup
    \brief The TabGroup component provides a group of items where
    only one item is visible at a time.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
*/

/*!
    \property Item TabGroup::currentTab
    \brief The item that is currently visible
    
    The default value is \c null.
*/

/*!
    \property int TabGroup::currentIndex
    \brief The index position of the item that is visible

    The current index is -1 if there is no current item.

    By default, this property contains a value of -1 because the group
    is initially empty.

    \sa currentTab
*/

/*!
    \property int TabGroup::count
    \brief The number of items contained by this group

    By default, this property contains a value of 0.

    \sa currentIndex, currentTab
*/

};

#endif // TabGroup_P_H
