/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TABBARSTYLE_P_H
#define TABBARSTYLE_P_H

class TabBarStyle : public Style
{
    
    Q_PROPERTY(Style firstTab READ firstTab WRITE setFirstTab)
    Q_PROPERTY(Style lastTab READ lastTab WRITE setLastTab)
    Q_PROPERTY(Style middleTab READ middleTab WRITE setMiddleTab)
    Q_PROPERTY(Style scroller READ scroller WRITE setScroller)
    Q_PROPERTY(Style selectedTab READ selectedTab WRITE setSelectedTab)
    Q_PROPERTY(Style tab READ tab WRITE setTab)
    Q_PROPERTY(Style tear READ tear WRITE setTear)
    
/*!
    \class TabBarStyle
    \brief TabBarStyle is a styling component for TabBar
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa TabBar
*/

/*!
    \property Style TabBarStyle::firstTab
    \brief Applies styling properties to the first tab of the TabBar
*/

/*!
    \property Style TabBarStyle::lastTab
    \brief Applies styling properties to the last tab of the TabBar
*/

/*!
    \property Style TabBarStyle::middleTab
    \brief Applies styling properties to the middle tabs of the TabBar
*/

/*!
    \property Style TabBarStyle::scroller
    \brief Applies styling properties to the scroller of the TabBar
*/

/*!
    \property Style TabBarStyle::selectedTab
    \brief Applies styling properties to the currently selected tab of the TabBar
*/

/*!
    \property Style TabBarStyle::tab
    \brief Applies styling properties to the tabs of the TabBar
*/

/*!
    \property Style TabBarStyle::tear
    \brief Applies styling properties to the tear of the TabBar
*/

};

#endif // TABBARSTYLE_P_H

