/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SORTFILTERPROXYMODEL_P_H
#define SORTFILTERPROXYMODEL_P_H

class SortFilterProxyModel
{
    
    Q_PROPERTY(regExp filterRegExp READ filterRegExp WRITE setFilterRegExp)
    Q_PROPERTY(int filterKeyColumn READ filterKeyColumn WRITE setFilterKeyColumn)
    Q_PROPERTY(bool dynamicSortFilter READ dynamicSortFilter WRITE setDynamicSortFilter)
    Q_PROPERTY(enumeration filterCaseSensitivity READ filterCaseSensitivity WRITE setFilterCaseSensitivity)
    Q_PROPERTY(enumeration sortCaseSensitivity READ sortCaseSensitivity WRITE setSortCaseSensitivity)
    Q_PROPERTY(bool isSortLocaleAware READ isSortLocaleAware WRITE setSortLocaleAware)
    Q_PROPERTY(string filterProperty READ filterProperty WRITE setFilterProperty)
    Q_PROPERTY(string sortProperty READ sortProperty WRITE setSortProperty)
    Q_PROPERTY(variant sourceModel READ sourceModel WRITE setSourceModel)
    
    
public:
    QModelIndex mapFromSourceModelIndex(QModelIndex sourceIndex);
    QModelIndex mapToSourceModelIndex(QModelIndex proxyIndex);
    
    void sort(int column, enumeration order = Qt.AscendingOrder);
    
/*!
    \class SortFilterProxyModel
    \brief The SortFilterProxyModel component provides support for sorting and
    filtering data passed between another model and a view.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-data

    SortFilterProxyModel can be used for sorting items, filtering out items,
    or both. The model transforms the structure of a source model by mapping
    the model indexes it supplies to new indexes, corresponding to different
    locations, for views to use. This approach allows a given source model to
    be restructured as far as views are concerned without requiring any
    transformations on the underlying data, and without duplicating the data in
    memory.
*/

/*!
    \property regExp SortFilterProxyModel::filterRegExp
    \brief The regular expression used to filter the contents of the source model

    Setting this property overwrites the current filterCaseSensitivity.
    By default, the regExp is an empty string matching all contents.

    If no regExp or an empty string is set, everything in the source model
    will be accepted.

    \sa filterCaseSensitivity
*/

/*!
    \property int SortFilterProxyModel::filterKeyColumn
    \brief The column where the key used to filter the contents of the
    source model is read from.

    The default value is 0. If the value is -1, the keys will be read
    from all columns.
*/

/*!
    \property enumeration SortFilterProxyModel::filterCaseSensitivity

    \brief The case sensitivity of the regExp pattern used to filter the
    contents of the source model

    By default, the filter is case sensitive.

    \sa filterRegExp, sortCaseSensitivity
*/

/*!
    \property enumeration SortFilterProxyModel::sortCaseSensitivity
    \brief The case sensitivity setting used for comparing strings when sorting

    By default, sorting is case sensitive.

    \sa filterCaseSensitivity
*/

/*!
    \property bool SortFilterProxyModel::isSortLocaleAware
    \brief The local aware setting used for comparing strings when sorting

    By default, sorting is not local aware.

    \sa sortCaseSensitivity
*/

/*!
    \property bool SortFilterProxyModel::dynamicSortFilter
    \brief Whether the proxy model is dynamically sorted and filtered
    whenever the contents of the source model change

    Note that you should not update the source model through the proxy
    model when dynamicSortFilter is true.

    The default value is false.
*/

/*!
    \property string SortFilterProxyModel::sortProperty
    \brief The property that is used to query the source model's data when sorting items
*/

/*!
    \property string SortFilterProxyModel::filterProperty
    \brief The property that is used to query the source model's data when filtering items
*/

/*!
    \fn QModelIndex SortFilterProxyModel::mapToSource(QModelIndex proxyIndex)
    
    Returns the source model index corresponding to the given \a
    proxyIndex from the sorting filter model.

    \sa mapFromSource()
*/

/*!
    \fn QModelIndex SortFilterProxyModel::mapFromSource(QModelIndex sourceIndex)
    
    Returns the model index in the SortFilterProxyModel given the \a
    sourceIndex from the source model.

    \sa mapToSource()
*/

/*!
    \fn void SortFilterProxyModel::sort(int column, enumeration order)
    
    Sorts the data in \a column according to \a order.
    
    \a order can be one of the following:
    
    \li \c Qt.AscendingOrder
    \li \c Qt.DescendingOrder
*/

};

#endif // SORTFILTERPROXYMODEL_P_H
