/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef QUERYDIALOG_P_H
#define QUERYDIALOG_P_H

class QueryDialog : public Dialog
{

    Q_PROPERTY(string messageText READ messageText WRITE setMessageText)
    Q_PROPERTY(string acceptButtonText READ acceptButtonText WRITE setAcceptButtonText)
    Q_PROPERTY(string rejectButtonText READ rejectButtonText WRITE setRejectButtonText)
    
/*!
    \class QueryDialog
    \brief The QueryDialog presents the user with a question
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    A QueryDialog is used for cases where an action requires 
    confirmation from the user, for example when a file is to 
    be deleted.
    
    \code
    Window {
        id: window
        
        Button {
            anchors.centerIn: parent
            text: "Quit"
            onClicked: queryDialog.open()
        }
        
        QueryDialog {
            id: queryDialog
            
            message: "Do you want to quit?"
            onAccepted: Qt.quit()
        }
    }
    \endcode
*/

/*!
    \property string QueryDialog::messageText
    \brief The text of the message label
    
    \sa Label::text
*/

/*!
    \property string QueryDialog::acceptButtonText
    \brief The text of the accept button
    
    \sa Button::text
*/

/*!
    \property string QueryDialog::rejectButtonText
    \brief The text of the reject button
    
    \sa Button::text
*/

};

#endif // QUERYDIALOG_P_H
