/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTITEMRECTANGLE_P_H
#define LISTITEMRECTANGLE_P_H

class ListItemRectangle : public ListItemContent
{
    Q_OBJECT

    Q_PROPERTY(color color READ color WRITE setColor NOTIFY colorChanged)
    Q_PROPERTY(real radius READ radius WRITE setRadius NOTIFY radiusChanged)
    Q_PROPERTY(Border border READ border CONSTANT FINAL)
    Q_PROPERTY(Gradient gradient READ gradient WRITE setGradient RESET resetGradient)

/*!
    \class ListItemRectangle
    \brief The ListItemRectangle component is used for displaying rectangles in ListItem
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-graphics
    \ingroup org-hildon-components-views
*/

/*!
    \property color ListItemRectangle::color
    \brief The color of the rectangle
*/

/*!
    \property real ListItemRectangle::radius
    \brief The radius of the rectangle
*/
};

#endif // LISTITEMRECTANGLE_P_H
