/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef LISTITEMMOUSEAREA_P_H
#define LISTITEMMOUSEAREA_P_H

class ListItemMouseArea : public ListItemContent
{

    Q_PROPERTY(bool containsMouse READ containsMouse)
    Q_PROPERTY(int mouseX READ mouseX)
    Q_PROPERTY(int mouseY READ mouseY)
    Q_PROPERTY(bool pressed READ isPressed)
    Q_PROPERTY(bool preventStealing READ preventStealing WRITE setPreventStealing)

signals:
    void canceled();
    void entered();
    void exited();
    void positionChanged(MouseEvent mouse);
    void pressed(MouseEvent mouse);
    void pressAndHold(MouseEvent mouse);
    void released(MouseEvent mouse);
    void clicked(MouseEvent mouse);
    void doubleClicked(MouseEvent mouse);
    
/*!
    \class ListItemMouseArea
    \brief The ListItemMouseArea component enables simple mouse handling in ListItem.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-interaction
    \ingroup org-hildon-components-views

    \sa MouseArea
*/

/*!
    \property real ListItemMouseArea::mouseX
    \brief The x coordinate of the mouse cursor.
*/

/*!
    \property real ListItemMouseArea::mouseY
    \brief The y coordinate of the mouse cursor.
*/

/*!
    \property bool ListItemMouseArea::preventStealing
    \brief Whether the mouse events may be stolen from this
    ListItemMouseArea.

    By default this property is false.
*/

/*!
    \property bool ListItemMouseArea::containsMouse
    \brief Whether the mouse is currently inside the mouse area.

    \warning This property is not updated if the area moves under the mouse: 
    \e containsMouse will not change.
*/

/*!
    \property bool ListItemMouseArea::pressed
    \brief Whether the mouse area is currently pressed.
*/

/*!
    \fn void ListItemMouseArea::entered()

    This signal is emitted when the mouse enters the mouse area.
*/

/*!
    \fn void ListItemMouseArea::exited()

    This signal is emitted when the mouse exits the mouse area.
*/

/*!
    \fn void ListItemMouseArea::positionChanged(MouseEvent mouse)

    This signal is emitted when the mouse position changes.

    The \e mouse parameter provides information about the mouse, including the x and y
    position, and any buttons currently pressed.

    The \e accepted property of the MouseEvent parameter is ignored in this handler.
*/

/*!
    \fn void ListItemMouseArea::clicked(MouseEvent mouse)

    This signal is emitted when there is a click. A click is defined as a press followed by a release,
    both inside the ListItemMouseArea (pressing, moving outside the ListItemMouseArea, and then moving back inside and
    releasing is also considered a click).

    The \e mouse parameter provides information about the click, including the x and y
    position of the release of the click, and whether the click was held.

    The \e accepted property of the MouseEvent parameter is ignored in this handler.
*/

/*!
    \fn void ListItemMouseArea::pressed(MouseEvent mouse)

    This signal is emitted when there is a press.
    The \e mouse parameter provides information about the press, including the x and y
    position and which button was pressed.

    The \e accepted property of the MouseEvent parameter determines whether this ListItemMouseArea
    will handle the press and all future mouse events until release.  The default is to accept
    the event and not allow other ListItemMouseArea beneath this one to handle the event.  If \e accepted
    is set to false, no further events will be sent to this ListItemMouseArea until the button is next
    pressed.
*/

/*!
    \fn void ListItemMouseArea::released(MouseEvent mouse)

    This signal is emitted when there is a release.
    The \e mouse parameter provides information about the click, including the x and y
    position of the release of the click, and whether the click was held.

    The \e accepted property of the MouseEvent parameter is ignored in this handler.

    \sa canceled()
*/

/*!
    \fn void ListItemMouseArea::pressAndHold(MouseEvent mouse)

    This signal is emitted when there is a long press (currently 800ms).
    The \e mouse parameter provides information about the press, including the x and y
    position of the press, and which button is pressed.

    The \e accepted property of the MouseEvent parameter is ignored in this handler.
*/

/*!
    \fn void ListItemMouseArea::doubleClicked(MouseEvent mouse)

    This signal is emitted when there is a double-click (a press followed by a release followed by a press).
    The \e mouse parameter provides information about the click, including the x and y
    position of the release of the click, and whether the click was held.

    If the \e accepted property of the \e mouse parameter is set to false
    in the handler, the pressed()/released()/clicked() signals will be emitted for the second
    click; otherwise they are suppressed.  The accepted property defaults to true.
*/

/*!
    \fn void ListItemMouseArea::canceled()

    This signal is emitted when mouse events have been canceled, 
    either because an event was not accepted, or
    because another item stole the mouse event handling.
*/

};

#endif // LISTITEMMOUSEAREA_P_H
