/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTITEMCONTENT_P_H
#define LISTITEMCONTENT_P_H

class ListItemContent
{

    Q_PROPERTY(Object parent READ parent WRITE setParent)
    Q_PROPERTY(int x READ x WRITE setX)
    Q_PROPERTY(int y READ y WRITE setY)
    Q_PROPERTY(int width READ width WRITE setWidth)
    Q_PROPERTY(int height READ height WRITE setHeight)
    Q_PROPERTY(real opacity READ opacity WRITE setOpacity)
    Q_PROPERTY(bool visible READ isVisible WRITE setVisible)
    Q_PROPERTY(bool enabled READ isEnabled WRITE setEnabled)
    Q_PROPERTY(bool smooth READ smooth WRITE setSmooth)
    Q_PROPERTY(Anchors anchors READ anchors CONSTANT)
    Q_PROPERTY(AnchorLine left READ left CONSTANT)
    Q_PROPERTY(AnchorLine right READ right CONSTANT)
    Q_PROPERTY(AnchorLine top READ top CONSTANT)
    Q_PROPERTY(AnchorLine bottom READ bottom CONSTANT)
    Q_PROPERTY(AnchorLine horizontalCenter READ horizontalCenter CONSTANT)
    Q_PROPERTY(AnchorLine verticalCenter READ verticalCenter CONSTANT)
    Q_PROPERTY(list<Object> data READ data)
    Q_PROPERTY(list<ListItemContent> content READ content)

/*!
    \class ListItemContent
    \brief ListItemContent is the base component for content in ListItem
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-views
    
    \warning This component cannot be created in QML.
*/

/*!
    \property bool ListItemContent::enabled
    \brief Whether the item is enabled

    In general an enabled item handles keyboard and mouse events; a disabled
    item does not.

    Some items display themselves differently when they are
    disabled. For example a button might draw its label grayed out.

    Disabling a item implicitly disables all its children. Enabling
    respectively enables all child items unless they have been
    explicitly disabled.

    By default, this property is true.
*/

/*!
    \property int ListItemContent::x
    \brief The x coordinate of the item relative to its parent including
    any window frame

    By default, this property has a value of 0.

    \sa y
*/

/*!
    \property int ListItemContent::y
    \brief The y coordinate of the item relative to its parent and
    including any window frame

    By default, this property has a value of 0.

    \sa x
*/

/*!
    \property int ListItemContent::width
    \brief The width of the item excluding any window frame

    By default, this property contains a value that depends on the screen geometry.

    \sa height
*/

/*!
    \property int ListItemContent::height
    \brief The height of the item excluding any window frame

    By default, this property contains a value that depends on the screen geometry.

    \sa width
*/

/*!
    \property bool ListItemContent::visible
    \brief Whether the item is visible

    Setting visible to \e true sets the item to visible
    status if all its parent items up to the window are visible.
    
    \sa opacity
*/

/*!
    \property real ListItemContent::opacity
    \brief The opacity of the item
    
    This property is also applied to the item's
    visual children.
    
    \sa visible
*/

/*!
    \property Anchors ListItemContent::anchors
    \brief The item's anchors
*/

/*!
    \property AnchorLine ListItemContent::left
    \brief The item's left anchor line
*/

/*!
    \property AnchorLine ListItemContent::right
    \brief The item's right anchor line
*/

/*!
    \property AnchorLine ListItemContent::top
    \brief The item's top anchor line
*/

/*!
    \property AnchorLine ListItemContent::bottom
    \brief The item's bottom anchor line
*/

/*!
    \property list<Object> ListItemContent::data
    \brief The item's child objects
*/

/*!
    \property list<ListItemContent> ListItemContent::content
    \brief The item's visual content
*/

};

#endif // LISTITEMCONTENT_P_H
