/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef ITEMACTION_P_H
#define ITEMACTION_P_H

class ItemAction : public Action
{

    Q_PROPERTY(Item item READ item WRITE setItem)
    
/*!
    \class ItemAction
    \brief The ItemAction component provides an Action that displays an Item

    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    ItemAction is most useful for displaying complex visual 
    items in the application menu, by assigning an ItemAction to the 
    tools property of Page or Window:
    
    \code
    Page {
        tools: [
            Action {
                text: "Action"
            },
            
            ItemAction {
                item: Slider {
                    onValueChanged: console.log(value)
                }
            }
        ]
    }
    \endcode
*/

/*!
    \property Item ItemAction::item
    \brief The action's item
    
    The Item assigned to this property is displayed 
    in place of the action.
*/

};

#endif // ITEMACTION_P_H
