/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef BUTTONROW_P_H
#define BUTTONROW_P_H

class ButtonRow : public Item
{

    Q_PROPERTY(bool exclusive READ exclusive WRITE setExclusive)

/*!
    \class ButtonRow
    \brief The ButtonRow component provides a horizontal layout container for Button.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    \ingroup org-hildon-components-positioning
    
    When a Button is declared as a child of the ButtonRow, 
    it will automatically be added to the row:
    
    \code
    ButtonRow {
        id: row
        
        anchors.centerIn: parent
        exclusive: true
        
        Button {
            id: buttonOne
            checkable: true
            text: "One"
        }
        
        Button {
            id: buttonTwo
            
            checkable: true
            checked: true
            text: "Two"
        }
        
        Button {
            id: buttonThree
            
            checkable: true
            text: "Three"
        }
    }
    \endcode
*/

/*!
    \property bool ButtonRow::exclusive
    
    Specifies whether only one button can be checked 
    at any one time.
    
    The default value is true.
*/

};

#endif // BUTTONROW_P_H
