/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef LISTELEMENT_P_H
#define LISTELEMENT_P_H

#include <QObject>
#include <qdeclarative.h>
#include <private/qdeclarativecustomparser_p.h>

class ListElement : public QObject
{
    Q_OBJECT
    
public:
    explicit ListElement(QObject *parent = 0);
    ~ListElement();
    
private:
    friend class ListElementParser;
    friend class ListModelPrivate;
    
    QByteArray data;
    
    Q_DISABLE_COPY(ListElement)
};

class ListElementParser : public QDeclarativeCustomParser
{
public:
    virtual QByteArray compile(const QList<QDeclarativeCustomParserProperty> &);
    virtual void setCustomData(QObject *, const QByteArray &);
    
private:
    bool compileProperty(const QDeclarativeCustomParserProperty &prop, QByteArray &data);
    bool definesEmptyList(const QString &);
    
    QByteArray listElementTypeName;
};
    
QML_DECLARE_TYPE(ListElement)

#endif // LISTELEMENT_P_H
