#ifndef QDECLARATIVEDBUSINTERFACE_H
#define QDECLARATIVEDBUSINTERFACE_H

#include <QObject>
#include <QVariantList>

class QDeclarativeItem;
class QDBusInterface;

class QDeclarativeDBusInterface : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString service
               READ service
               WRITE setService)
    Q_PROPERTY(QString path
               READ path
               WRITE setPath)
    Q_PROPERTY(QString interfaceName
               READ interface
               WRITE setInterface)

public:
    explicit QDeclarativeDBusInterface(QDeclarativeItem *parent = 0);
    QString service() const;
    void setService(const QString &service);
    QString path() const;
    void setPath(const QString &path);
    QString interface() const;
    void setInterface(const QString &interface);
    Q_INVOKABLE void call(const QString &method, const QVariantList &args = QVariantList());

private:
    QDBusInterface *m_iface;
    QString m_service;
    QString m_path;
    QString m_interface;
};

#endif // QDECLARATIVEDBUSINTERFACE_H
